/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.AbstractComponentBehavior;
import com.alee.managers.drag.DragListener;
import com.alee.managers.drag.DragManager;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class AbstractObjectHoverBehavior<C extends JComponent, V>
extends AbstractComponentBehavior<C>
implements MouseListener,
MouseMotionListener,
ComponentListener,
AncestorListener,
DragListener,
PropertyChangeListener {
    protected final boolean enabledOnly;
    @Nullable
    protected V hoverObject;

    public AbstractObjectHoverBehavior(@NotNull C component) {
        this(component, true);
    }

    public AbstractObjectHoverBehavior(@NotNull C component, boolean enabledOnly) {
        super(component);
        this.enabledOnly = enabledOnly;
    }

    public void install() {
        ((JComponent)this.component).addMouseListener(this);
        ((JComponent)this.component).addMouseMotionListener(this);
        ((JComponent)this.component).addAncestorListener(this);
        ((JComponent)this.component).addComponentListener(this);
        ((JComponent)this.component).addPropertyChangeListener("enabled", this);
        DragManager.addDragListener((JComponent)this.component, this);
    }

    public void uninstall() {
        DragManager.removeDragListener((JComponent)this.component, this);
        ((JComponent)this.component).removePropertyChangeListener("enabled", this);
        ((JComponent)this.component).removeComponentListener(this);
        ((JComponent)this.component).removeAncestorListener(this);
        ((JComponent)this.component).removeMouseMotionListener(this);
        ((JComponent)this.component).removeMouseListener(this);
        this.hoverObject = null;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event) {
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event) {
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        this.updateHover(event);
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent event) {
        this.updateHover(event);
    }

    @Override
    public void mouseExited(@NotNull MouseEvent event) {
        this.clearHover();
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event) {
        this.updateHover(event);
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent event) {
        this.updateHover(event);
    }

    @Override
    public void ancestorAdded(@NotNull AncestorEvent event) {
        this.updateHover();
    }

    @Override
    public void ancestorRemoved(@NotNull AncestorEvent event) {
        this.updateHover();
    }

    @Override
    public void ancestorMoved(@NotNull AncestorEvent event) {
        this.updateHover();
    }

    @Override
    public void componentResized(@NotNull ComponentEvent event) {
        this.updateHover();
    }

    @Override
    public void componentMoved(@NotNull ComponentEvent event) {
        this.updateHover();
    }

    @Override
    public void componentShown(@NotNull ComponentEvent event) {
        this.updateHover();
    }

    @Override
    public void componentHidden(@NotNull ComponentEvent event) {
        this.updateHover();
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (this.enabledOnly) {
            if (((JComponent)this.component).isEnabled()) {
                this.updateHover();
            } else {
                this.clearHover();
            }
        }
    }

    @Override
    public void started(@NotNull DragSourceDragEvent event) {
    }

    @Override
    public void entered(@NotNull DragSourceDragEvent event) {
        this.updateHover();
    }

    @Override
    public void moved(@NotNull DragSourceDragEvent event) {
    }

    @Override
    public void exited(@NotNull DragSourceEvent event) {
        this.updateHover();
    }

    @Override
    public void finished(@NotNull DragSourceDropEvent event) {
        this.updateHover();
    }

    protected void updateHover() {
        if (((JComponent)this.component).isShowing() && !DragManager.isDragging()) {
            JRootPane rootPane = CoreSwingUtils.getRootPane((Component)this.component);
            if (rootPane != null) {
                Point windowPoint = CoreSwingUtils.getMouseLocation((Component)rootPane);
                Component topComponentAt = CoreSwingUtils.getTopComponentAt((Component)rootPane, (Point)windowPoint);
                if (topComponentAt == this.component) {
                    Point mouseLocation = CoreSwingUtils.getMouseLocation((Component)this.component);
                    if (((JComponent)this.component).getVisibleRect().contains(mouseLocation)) {
                        this.updateHover(mouseLocation);
                    } else {
                        this.clearHover();
                    }
                } else {
                    this.clearHover();
                }
            } else {
                this.clearHover();
            }
        } else {
            this.clearHover();
        }
    }

    protected void updateHover(@NotNull MouseEvent e) {
        this.updateHover(e.getPoint());
    }

    protected void updateHover(@NotNull Point point) {
        if (!this.enabledOnly || ((JComponent)this.component).isEnabled()) {
            this.checkHoverChange(this.getObjectAt(point));
        }
    }

    @Nullable
    protected abstract V getObjectAt(@NotNull Point var1);

    protected void clearHover() {
        this.checkHoverChange(this.getEmptyObject());
    }

    @Nullable
    protected abstract V getEmptyObject();

    protected void checkHoverChange(@Nullable V object) {
        if (Objects.notEquals(object, this.hoverObject)) {
            V previousPath = this.hoverObject;
            this.hoverObject = object;
            this.hoverChanged(previousPath, this.hoverObject);
        }
    }

    public abstract void hoverChanged(V var1, V var2);
}

