/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.api.annotations.NotNull;
import com.alee.api.merge.Mergeable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;

@XStreamAlias(value="BreadcrumbLayout")
public class BreadcrumbLayout
extends AbstractLayoutManager
implements Mergeable,
Cloneable,
Serializable {
    @XStreamAsAttribute
    protected Strategy strategy;
    @XStreamAsAttribute
    protected Integer overlap;

    public BreadcrumbLayout() {
        this(Strategy.fillLast, 0);
    }

    public BreadcrumbLayout(Strategy strategy, int overlap) {
        this.strategy = strategy;
        this.overlap = overlap;
    }

    public Strategy strategy() {
        return this.strategy != null ? this.strategy : Strategy.fillLast;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public int overlap() {
        return this.overlap != null ? this.overlap : 0;
    }

    public void setOverlap(int overlap) {
        this.overlap = overlap;
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Insets insets = container.getInsets();
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        int componentCount = container.getComponentCount();
        switch (this.strategy()) {
            case allPreferred: 
            case fillLast: {
                if (ltr) {
                    int x = insets.left;
                    for (int i = 0; i < componentCount; ++i) {
                        Component component = container.getComponent(i);
                        Dimension ps = component.getPreferredSize();
                        if (this.strategy() != Strategy.fillLast || i != componentCount - 1) {
                            component.setBounds(x, insets.top, ps.width, container.getHeight() - insets.top - insets.bottom);
                        } else {
                            int w = Math.max(ps.width, container.getWidth() - x - insets.right);
                            component.setBounds(x, insets.top, w, container.getHeight() - insets.top - insets.bottom);
                        }
                        x += ps.width - this.overlap;
                    }
                } else {
                    int x = container.getWidth() - insets.right;
                    for (int i = 0; i < componentCount; ++i) {
                        Component component = container.getComponent(i);
                        Dimension ps = component.getPreferredSize();
                        if (this.strategy() != Strategy.fillLast || i != componentCount - 1) {
                            component.setBounds(x - ps.width, insets.top, ps.width, container.getHeight() - insets.top - insets.bottom);
                        } else {
                            int w = Math.max(ps.width, x - insets.left);
                            component.setBounds(x - w, insets.top, w, container.getHeight() - insets.top - insets.bottom);
                        }
                        x += this.overlap - ps.width;
                    }
                }
                break;
            }
            case allEqual: {
                Dimension max = this.maxComponentSize(container);
                if (ltr) {
                    int x = insets.left;
                    for (int i = 0; i < componentCount; ++i) {
                        Component component = container.getComponent(i);
                        component.setBounds(x, insets.top, max.width, container.getHeight() - insets.top - insets.bottom);
                        x += max.width - this.overlap;
                    }
                } else {
                    int x = container.getWidth() - insets.right;
                    for (int i = 0; i < componentCount; ++i) {
                        Component component = container.getComponent(i);
                        component.setBounds(x - max.width, insets.top, max.width, container.getHeight() - insets.top - insets.bottom);
                        x += this.overlap - max.width;
                    }
                }
                break;
            }
            case fillAll: {
                int available = container.getWidth() - insets.left - insets.right;
                int part = componentCount > 1 ? available / componentCount + this.overlap : available;
                int left = available;
                if (ltr) {
                    int x = insets.left;
                    for (int i = 0; i < componentCount; ++i) {
                        Component component = container.getComponent(i);
                        int w = i < componentCount - 1 ? part : left;
                        component.setBounds(x, insets.top, w, container.getHeight() - insets.top - insets.bottom);
                        x += w - this.overlap;
                        left -= part - this.overlap;
                    }
                } else {
                    int x = container.getWidth() - insets.right;
                    for (int i = 0; i < componentCount; ++i) {
                        Component component = container.getComponent(i);
                        int w = i < componentCount - 1 ? part : left;
                        component.setBounds(x - w, insets.top, w, container.getHeight() - insets.top - insets.bottom);
                        x += this.overlap - w;
                        left -= part - this.overlap;
                    }
                }
                break;
            }
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Dimension ps = new Dimension(0, 0);
        int componentCount = container.getComponentCount();
        if (componentCount > 0) {
            switch (this.strategy()) {
                case allPreferred: 
                case fillLast: {
                    for (int i = 0; i < componentCount; ++i) {
                        Dimension cps = container.getComponent(i).getPreferredSize();
                        ps.width = ps.width + (cps.width - (i < componentCount - 1 ? this.overlap : 0));
                        ps.height = Math.max(ps.height, cps.height);
                    }
                    break;
                }
                case allEqual: 
                case fillAll: {
                    Dimension max = this.maxComponentSize(container);
                    ps.width = max.width * componentCount - this.overlap * (componentCount - 1);
                    ps.height = max.height;
                }
            }
        }
        Insets insets = container.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    protected Dimension maxComponentSize(Container container) {
        Dimension max = new Dimension(0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Dimension cps = container.getComponent(i).getPreferredSize();
            max.width = Math.max(max.width, cps.width);
            max.height = Math.max(max.height, cps.height);
        }
        return max;
    }

    @XStreamAlias(value="BreadcrumbLayout$UIResource")
    public static final class UIResource
    extends BreadcrumbLayout
    implements javax.swing.plaf.UIResource {
    }

    public static enum Strategy {
        allPreferred,
        fillLast,
        allEqual,
        fillAll;

    }
}

