/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.api.annotations.NotNull;
import com.alee.extended.WebContainer;
import com.alee.extended.breadcrumb.BreadcrumbLayout;
import com.alee.extended.breadcrumb.WBreadcrumbUI;
import com.alee.extended.breadcrumb.element.BreadcrumbElementData;
import com.alee.extended.breadcrumb.element.BreadcrumbElementPainter;
import com.alee.extended.button.WebSplitButton;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.extended.date.WebDateField;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.link.WebLink;
import com.alee.managers.style.ComponentException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class WebBreadcrumb
extends WebContainer<WebBreadcrumb, WBreadcrumbUI> {
    public static final String FORCE_STYLE_PROPERTY = "forceStyle";
    protected boolean forceStyle = true;
    protected transient Map<JComponent, BreadcrumbElementData> data = new HashMap<JComponent, BreadcrumbElementData>(5);

    public WebBreadcrumb() {
        this(StyleId.auto);
    }

    public WebBreadcrumb(StyleId id) {
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    public BreadcrumbLayout getLayout() {
        return (BreadcrumbLayout)super.getLayout();
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.breadcrumb;
    }

    public boolean isForceStyle() {
        return this.forceStyle;
    }

    public void setForceStyle(boolean forceStyle) {
        boolean previous = this.forceStyle;
        this.forceStyle = forceStyle;
        this.firePropertyChange(FORCE_STYLE_PROPERTY, previous, forceStyle);
    }

    @Override
    protected void addImpl(Component component, Object constraints, int index) {
        Component next;
        Component previous;
        if (this.isSupported(component)) {
            this.data.put((JComponent)component, new BreadcrumbElementData());
            if (component instanceof JPanel) {
                StyleManager.setStyleId((JPanel)component, StyleId.breadcrumbPanel.at(this));
            } else if (component instanceof WebLink) {
                StyleManager.setStyleId((WebLink)component, StyleId.breadcrumbLink.at(this));
            } else if (component instanceof WebStyledLabel) {
                StyleManager.setStyleId((WebStyledLabel)component, StyleId.breadcrumbStyledLabel.at(this));
            } else if (component instanceof JLabel) {
                StyleManager.setStyleId((JLabel)component, StyleId.breadcrumbLabel.at(this));
            } else if (component instanceof WebTristateCheckBox) {
                StyleManager.setStyleId((WebTristateCheckBox)component, StyleId.breadcrumbTristateCheckBox.at(this));
            } else if (component instanceof JCheckBox) {
                StyleManager.setStyleId((JCheckBox)component, StyleId.breadcrumbCheckBox.at(this));
            } else if (component instanceof JRadioButton) {
                StyleManager.setStyleId((JRadioButton)component, StyleId.breadcrumbRadioButton.at(this));
            } else if (component instanceof WebSplitButton) {
                StyleManager.setStyleId((WebSplitButton)component, StyleId.breadcrumbSplitButton.at(this));
            } else if (component instanceof JToggleButton) {
                StyleManager.setStyleId((JToggleButton)component, StyleId.breadcrumbToggleButton.at(this));
            } else if (component instanceof JButton) {
                StyleManager.setStyleId((JButton)component, StyleId.breadcrumbButton.at(this));
            } else if (component instanceof JFormattedTextField) {
                StyleManager.setStyleId((JFormattedTextField)component, StyleId.breadcrumbFormattedTextField.at(this));
            } else if (component instanceof JPasswordField) {
                StyleManager.setStyleId((JPasswordField)component, StyleId.breadcrumbPasswordField.at(this));
            } else if (component instanceof JTextField) {
                StyleManager.setStyleId((JTextField)component, StyleId.breadcrumbTextField.at(this));
            } else if (component instanceof JComboBox) {
                StyleManager.setStyleId((JComboBox)component, StyleId.breadcrumbComboBox.at(this));
            } else if (component instanceof WebDateField) {
                StyleManager.setStyleId((WebDateField)component, StyleId.breadcrumbDateField.at(this));
            } else {
                throw new ComponentException("Unsupported breadcrumb element: " + component);
            }
        }
        super.addImpl(component, constraints, index);
        int actualIndex = this.getComponentZOrder(component);
        DecorationUtils.fireStatesChanged((JComponent)component);
        if (actualIndex > 0 && PainterSupport.isDecoratable(previous = this.getComponent(actualIndex - 1))) {
            DecorationUtils.fireStatesChanged((JComponent)previous);
        }
        if (actualIndex < this.getComponentCount() - 1 && PainterSupport.isDecoratable(next = this.getComponent(actualIndex + 1))) {
            DecorationUtils.fireStatesChanged((JComponent)next);
        }
    }

    protected boolean isSupported(Component component) {
        return component instanceof JPanel || component instanceof JLabel || component instanceof WebStyledLabel || component instanceof WebLink || component instanceof JButton || component instanceof JToggleButton || component instanceof WebSplitButton || component instanceof JComboBox || component instanceof WebDateField || component instanceof JCheckBox || component instanceof WebTristateCheckBox || component instanceof JRadioButton || component instanceof JTextField || component instanceof JFormattedTextField || component instanceof JPasswordField;
    }

    @Override
    public void remove(int index) {
        Component next;
        Component previous;
        Component component = this.getComponent(index);
        if (this.isApplied(component)) {
            this.data.remove(component);
        }
        super.remove(index);
        DecorationUtils.fireStatesChanged((JComponent)component);
        if (index > 0 && PainterSupport.isDecoratable(previous = this.getComponent(index - 1))) {
            DecorationUtils.fireStatesChanged((JComponent)previous);
        }
        if (index < this.getComponentCount() && PainterSupport.isDecoratable(next = this.getComponent(index))) {
            DecorationUtils.fireStatesChanged((JComponent)next);
        }
    }

    protected boolean isApplied(@NotNull Component component) {
        return PainterSupport.getPainter(component) instanceof BreadcrumbElementPainter;
    }

    public boolean isFirst(Component component) {
        return component == this.getFirstComponent();
    }

    public boolean isLast(Component component) {
        return component == this.getLastComponent();
    }

    public BreadcrumbElementData.ProgressType getProgressType(JComponent component) {
        return this.data(component).getProgressType();
    }

    public void setProgressType(JComponent component, BreadcrumbElementData.ProgressType type) {
        this.data(component).setProgressType(type);
        DecorationUtils.fireStatesChanged(component);
        this.repaint();
    }

    public double getProgress(JComponent component) {
        return this.data(component).getProgress();
    }

    public void setProgress(JComponent component, double progress) {
        this.data(component).setProgress(progress);
        DecorationUtils.fireStatesChanged(component);
        this.repaint();
    }

    protected BreadcrumbElementData data(JComponent component) {
        BreadcrumbElementData data = this.data.get(component);
        if (data == null) {
            throw new ComponentException("Specified JComponent is representing breadcrumb element: " + component);
        }
        return data;
    }

    @Override
    public WBreadcrumbUI getUI() {
        return (WBreadcrumbUI)this.ui;
    }

    public void setUI(WBreadcrumbUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

