/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.ListCellParameters;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.window.WebWindow;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.file.FileComparator;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebFileBreadcrumb
extends WebBreadcrumb {
    public static ImageIcon typeIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/type.png"));
    public static ImageIcon dateIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/date.png"));
    public static ImageIcon sizeIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/size.png"));
    private boolean displayFileIcon = true;
    private boolean displayFileName = true;
    private boolean displayFileTip = true;
    private int fileNameLength = 0;
    private int listFileNameLength = 30;
    private boolean showFullNameInTip = true;
    private int maxVisibleListFiles = 8;
    private boolean autoExpandLastElement = false;
    private File root;
    private File currentFile;

    public WebFileBreadcrumb() {
        this(FileUtils.getSystemRoot());
    }

    public WebFileBreadcrumb(String root) {
        this(new File(root));
    }

    public WebFileBreadcrumb(File root) {
        this.setRoot(root);
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.setRoot(new File(root));
    }

    public void setRoot(File root) {
        this.root = root.getAbsoluteFile();
        this.setCurrentFile(root);
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String currentFile) {
        this.setCurrentFile(new File(currentFile));
    }

    public void setCurrentFile(File currentFile) {
        if (!FileUtils.equals((File)this.root, (File)(currentFile = currentFile.getAbsoluteFile())) && !FileUtils.isParent((File)this.root, (File)currentFile)) {
            this.root = FileUtils.getTopParent((File)currentFile);
        }
        this.currentFile = currentFile;
        this.updatePath();
    }

    public boolean isDisplayFileIcon() {
        return this.displayFileIcon;
    }

    public void setDisplayFileIcon(boolean displayFileIcon) {
        this.displayFileIcon = displayFileIcon;
        this.updatePath();
    }

    public boolean isDisplayFileName() {
        return this.displayFileName;
    }

    public void setDisplayFileName(boolean displayFileName) {
        this.displayFileName = displayFileName;
        this.updatePath();
    }

    public boolean isDisplayFileTip() {
        return this.displayFileTip;
    }

    public void setDisplayFileTip(boolean displayFileTip) {
        this.displayFileTip = displayFileTip;
        this.updatePath();
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength;
        this.updatePath();
    }

    public int getListFileNameLength() {
        return this.listFileNameLength;
    }

    public void setListFileNameLength(int listFileNameLength) {
        this.listFileNameLength = listFileNameLength;
    }

    public boolean isShowFullNameInTip() {
        return this.showFullNameInTip;
    }

    public void setShowFullNameInTip(boolean showFullNameInTip) {
        this.showFullNameInTip = showFullNameInTip;
        this.updatePath();
    }

    public int getMaxVisibleListFiles() {
        return this.maxVisibleListFiles;
    }

    public void setMaxVisibleListFiles(int maxVisibleListFiles) {
        this.maxVisibleListFiles = maxVisibleListFiles;
    }

    public boolean isAutoExpandLastElement() {
        return this.autoExpandLastElement;
    }

    public void setAutoExpandLastElement(boolean autoExpandLastElement) {
        this.autoExpandLastElement = autoExpandLastElement;
    }

    private void updatePath() {
        this.removeAll();
        File current = this.currentFile;
        while (!FileUtils.equals((File)current, (File)this.root)) {
            this.addFile(current);
            current = FileUtils.getParent((File)current);
        }
        this.addFile(this.root);
    }

    private void addFile(final File file) {
        if (file.isDirectory()) {
            boolean showFullName = this.showFullNameInTip;
            final WebButton fileButton = new WebButton();
            if (this.displayFileIcon) {
                fileButton.setIcon(FileUtils.getFileIcon((File)file));
            }
            if (this.displayFileName) {
                String fileName = FileUtils.getDisplayFileName((File)file);
                String shortName = FileUtils.getShortFileName((String)fileName, (int)this.fileNameLength);
                showFullName = showFullName && shortName.length() != fileName.length();
                fileButton.setText(shortName);
            }
            if (this.displayFileTip) {
                this.installTip(file, fileButton, showFullName);
            }
            fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File[] files = file.listFiles();
                    if (files != null && files.length > 0) {
                        Arrays.sort(files, new FileComparator());
                        WebFileBreadcrumb.this.showFilesPopup(files, fileButton);
                    } else {
                        TooltipManager.showOneTimeTooltip((JComponent)fileButton, null, "There are no files inside");
                    }
                }
            });
            this.add((Component)fileButton, 0);
        } else {
            boolean showFullName = this.showFullNameInTip;
            WebLabel fileButton = new WebLabel();
            if (this.displayFileIcon) {
                fileButton.setIcon(FileUtils.getFileIcon((File)file));
            }
            if (this.displayFileName) {
                String fileName = FileUtils.getDisplayFileName((File)file);
                String shortName = FileUtils.getShortFileName((String)fileName, (int)this.fileNameLength);
                showFullName = showFullName && shortName.length() != fileName.length();
                fileButton.setText(shortName);
            }
            if (this.displayFileTip) {
                this.installTip(file, fileButton, showFullName);
            }
            this.add((Component)fileButton, 0);
        }
    }

    private void showFilesPopup(File[] files, final WebButton fileButton) {
        Insets bi;
        WebWindow window = new WebWindow(CoreSwingUtils.getNonNullWindowAncestor((Component)fileButton));
        window.setCloseOnFocusLoss(true);
        window.setAlwaysOnTop(true);
        final WebList list = new WebList(files);
        list.setSelectOnHover(true);
        list.setSelectedIndex(0);
        list.setVisibleRowCount(Math.min(this.maxVisibleListFiles, files.length));
        list.setCellRenderer(new WebListCellRenderer<File, WebList, ListCellParameters<File, WebList>>(){

            @Override
            protected Icon iconForValue(ListCellParameters<File, WebList> parameters) {
                return FileUtils.getFileIcon((File)parameters.value());
            }

            @Override
            protected String textForValue(ListCellParameters<File, WebList> parameters) {
                String fileName = FileUtils.getDisplayFileName((File)parameters.value());
                return FileUtils.getShortFileName((String)fileName, (int)WebFileBreadcrumb.this.listFileNameLength);
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (list.getSelectedIndex() != -1) {
                    WebFileBreadcrumb.this.setCurrentFile((File)list.getSelectedValue());
                    Component lc = WebFileBreadcrumb.this.getLastComponent();
                    lc.requestFocusInWindow();
                    if (WebFileBreadcrumb.this.autoExpandLastElement && lc instanceof AbstractButton) {
                        ((AbstractButton)lc).doClick();
                    }
                }
            }
        };
        list.addMouseListener(mouseAdapter);
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.ESCAPE.isTriggered(e)) {
                    fileButton.requestFocusInWindow();
                }
            }
        });
        WebScrollPane listScroll = new WebScrollPane(StyleId.scrollpaneUndecorated, list);
        window.add(listScroll);
        window.applyComponentOrientation(this.getComponentOrientation());
        window.pack();
        Point los = CoreSwingUtils.locationOnScreen((Component)fileButton);
        ListCellRenderer cellRenderer = list.getCellRenderer();
        Insets insets = bi = cellRenderer instanceof JComponent ? ((JComponent)((Object)cellRenderer)).getBorder().getBorderInsets(list) : new Insets(0, 0, 0, 0);
        if (this.getComponentOrientation().isLeftToRight()) {
            window.setLocation(los.x + fileButton.getInsets().left - listScroll.getInsets().left - bi.left, los.y + fileButton.getHeight() + 2);
        } else {
            window.setLocation(los.x + fileButton.getWidth() - fileButton.getInsets().right - listScroll.getWidth() + listScroll.getInsets().right + bi.right, los.y + fileButton.getHeight() + 2);
        }
        window.setVisible(true);
        list.requestFocusInWindow();
    }

    private void installTip(File file, final JComponent component, boolean showFullName) {
        WebPanel panel = new WebPanel((LayoutManager)new VerticalFlowLayout(4, 4), new Component[0]);
        panel.setOpaque(false);
        if (showFullName) {
            panel.add((Component)new WebLabel(FileUtils.getDisplayFileName((File)file), FileUtils.getFileIcon((File)file)));
            panel.add((Component)new WebSeparator(0));
        }
        panel.add((Component)new WebLabel(FileUtils.getFileTypeDescription((File)file), (Icon)typeIcon));
        if (FileUtils.isFile((File)file)) {
            panel.add((Component)new WebLabel(FileUtils.getDisplayFileModificationDate((File)file), (Icon)dateIcon));
            panel.add((Component)new WebLabel(FileUtils.getDisplayFileSize((File)file), (Icon)sizeIcon));
        }
        TooltipManager.setTooltip(component, panel);
        component.addAncestorListener((AncestorListener)new AncestorAdapter(){

            public void ancestorRemoved(AncestorEvent event) {
                TooltipManager.removeTooltips(component);
            }
        });
    }
}

