/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.button.WebSwitch;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class WebSwitchLayout
extends AbstractLayoutManager {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String GRIPPER = "GRIPPER";
    private final Map<Component, String> constraints = new HashMap<Component, String>();

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        String value = (String)constraints;
        if (value == null || !value.equals(LEFT) && !value.equals(RIGHT) && !value.equals(GRIPPER)) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be 'LEFT'/'RIGHT'/'GRIPPER' string");
        }
        this.constraints.put(component, value);
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        this.constraints.remove(component);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (Map.Entry<Component, String> constraint : this.constraints.entrySet()) {
            Dimension ps = constraint.getKey().getPreferredSize();
            maxWidth = Math.max(ps.width, maxWidth);
            maxHeight = Math.max(ps.height, maxHeight);
        }
        Insets insets = container.getInsets();
        return new Dimension(insets.left + maxWidth * 2 + insets.right, insets.top + maxHeight + insets.bottom);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        if (container instanceof WebSwitch) {
            WebSwitch wswitch = (WebSwitch)container;
            boolean ltr = wswitch.getComponentOrientation().isLeftToRight();
            Insets insets = wswitch.getInsets();
            int width = wswitch.getWidth() - insets.left - insets.right;
            int partWidth = width / 2;
            int height = wswitch.getHeight() - insets.top - insets.bottom;
            int leftX = insets.left;
            int rightX = leftX + width / 2;
            int y = insets.top;
            for (Map.Entry<Component, String> entry : this.constraints.entrySet()) {
                String constraint = entry.getValue();
                if (constraint.equals(GRIPPER)) {
                    float gl = wswitch.getGripperLocation();
                    int x = ltr ? leftX + Math.round(gl * (float)partWidth) : rightX - Math.round(gl * (float)partWidth);
                    entry.getKey().setBounds(x, y, partWidth, height);
                    continue;
                }
                if (ltr ? constraint.equals(LEFT) : constraint.equals(RIGHT)) {
                    entry.getKey().setBounds(leftX, y, partWidth, height);
                    continue;
                }
                if (!(ltr ? constraint.equals(RIGHT) : constraint.equals(LEFT))) continue;
                entry.getKey().setBounds(rightX, y, partWidth, height);
            }
        } else {
            throw new RuntimeException("WebSwitchLayout works only inside of the WebSwitch component");
        }
    }
}

