/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.canvas;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

@XStreamAlias(value="Gripper")
public class Gripper<C extends JComponent, D extends IDecoration<C, D>, I extends Gripper<C, D, I>>
extends AbstractContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected CompassDirection direction;
    @XStreamAsAttribute
    @Nullable
    protected Dimension part;
    @XStreamAsAttribute
    @Nullable
    protected Integer spacing;
    @XStreamAsAttribute
    @Nullable
    protected Color color;
    @XStreamAsAttribute
    @Nullable
    protected Color shadow;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "gripper";
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return false;
    }

    @NotNull
    public CompassDirection getDirection(@NotNull C c, @NotNull D d) {
        return this.direction != null ? this.direction : CompassDirection.southEast;
    }

    @NotNull
    public Dimension getPart(@NotNull C c, @NotNull D d) {
        return this.part != null ? this.part : new Dimension(2, 2);
    }

    public int getSpacing(@NotNull C c, @NotNull D d) {
        return this.spacing != null ? this.spacing : 1;
    }

    @NotNull
    public Color getColor(@NotNull C c, @NotNull D d) {
        return this.color != null ? this.color : Color.WHITE;
    }

    @NotNull
    public Color getShadow(@NotNull C c, @NotNull D d) {
        return this.shadow != null ? this.shadow : Color.LIGHT_GRAY;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        int x;
        CompassDirection direction = this.getDirection(c, d);
        Dimension part = this.getPart(c, d);
        int spacing = this.getSpacing(c, d);
        Dimension gripSize = this.getGripSize(part, spacing);
        switch (direction) {
            case northWest: 
            case west: 
            case southWest: {
                x = bounds.x + spacing;
                break;
            }
            case northEast: 
            case east: 
            case southEast: {
                x = bounds.x + bounds.width - gripSize.width + spacing;
                break;
            }
            default: {
                x = bounds.x + bounds.width / 2 - gripSize.width / 2 + spacing;
            }
        }
        for (int col = 0; col <= 2; ++col) {
            int y;
            switch (direction) {
                case northWest: 
                case west: 
                case southWest: {
                    y = bounds.y + spacing;
                    break;
                }
                case northEast: 
                case east: 
                case southEast: {
                    y = bounds.y + bounds.height - gripSize.height + spacing;
                    break;
                }
                default: {
                    y = bounds.y + bounds.height / 2 - gripSize.height / 2 + spacing;
                }
            }
            for (int row = 0; row <= 2; ++row) {
                this.paintGrip(g2d, c, d, col, row, x, y, direction, part);
                y = (int)((double)y + ((double)part.height * 1.5 + (double)spacing));
            }
            x = (int)((double)x + ((double)part.width * 1.5 + (double)spacing));
        }
    }

    protected void paintGrip(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, int col, int row, int x, int y, @NotNull CompassDirection direction, @NotNull Dimension part) {
        boolean paint = false;
        switch (direction) {
            case northWest: {
                paint = row == 0 || row == 1 && col < 2 || row == 2 && col == 0;
                break;
            }
            case north: {
                paint = row == 0;
                break;
            }
            case northEast: {
                paint = row == 0 || row == 1 && col > 0 || row == 2 && col == 2;
                break;
            }
            case west: {
                paint = col == 0;
                break;
            }
            case center: {
                paint = true;
                break;
            }
            case east: {
                paint = col == 2;
                break;
            }
            case southWest: {
                paint = row == 0 && col == 0 || row == 1 && col < 2 || row == 2;
                break;
            }
            case south: {
                paint = row == 2;
                break;
            }
            case southEast: {
                boolean bl = paint = row == 0 && col == 2 || row == 1 && col > 0 || row == 2;
            }
        }
        if (paint) {
            this.paintGripPart(g2d, c, d, x, y, part);
        }
    }

    protected void paintGripPart(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, int x, int y, @NotNull Dimension part) {
        int w = Math.round((float)part.width * 1.5f);
        int h = Math.round((float)part.height * 1.5f);
        g2d.setPaint(this.getShadow(c, d));
        g2d.fillRect(x + w - part.width, y + h - part.height, part.width, part.height);
        g2d.setPaint(this.getColor(c, d));
        g2d.fillRect(x, y, part.width, part.height);
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        return this.getGripSize(this.getPart(c, d), this.getSpacing(c, d));
    }

    @NotNull
    protected Dimension getGripSize(@NotNull Dimension part, int spacing) {
        int w = (int)Math.round((double)part.width * 1.5 * 3.0 + (double)(spacing * 4));
        int h = (int)Math.round((double)part.height * 1.5 * 3.0 + (double)(spacing * 4));
        return new Dimension(w, h);
    }
}

