/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.collapsible.AbstractControlButton;
import com.alee.extended.collapsible.AbstractHeaderPanel;
import com.alee.extended.collapsible.AbstractTitleLabel;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.managers.style.StyleId;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class HeaderLayout
extends AbstractLayoutManager {
    public static final String TITLE = "title";
    public static final String CONTROL = "control";
    @Nullable
    protected Component title;
    @Nullable
    protected Component control;

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        AbstractHeaderPanel headerPanel = (AbstractHeaderPanel)component.getParent();
        if (Objects.equals((Object)constraints, (Object)TITLE)) {
            this.title = component;
            if (this.title instanceof AbstractTitleLabel.UIResource) {
                StyleId.collapsiblepaneTitleLabel.at(headerPanel).set((AbstractTitleLabel.UIResource)this.title);
            }
        } else if (Objects.equals((Object)constraints, (Object)CONTROL)) {
            this.control = component;
            if (this.control instanceof AbstractControlButton.UIResource) {
                StyleId.collapsiblepaneControlButton.at(headerPanel).set((AbstractControlButton.UIResource)this.control);
            }
        } else {
            throw new IllegalArgumentException("Unknown constraints: " + constraints);
        }
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        if (component == this.title) {
            if (this.title instanceof AbstractTitleLabel.UIResource) {
                ((AbstractTitleLabel.UIResource)this.title).resetStyleId();
            }
            this.title = null;
        } else if (component == this.control) {
            if (this.control instanceof AbstractControlButton.UIResource) {
                ((AbstractControlButton.UIResource)this.control).resetStyleId();
            }
            this.control = null;
        } else {
            throw new IllegalArgumentException("Component was not added into header before: " + component);
        }
    }

    @Nullable
    public Component getTitle() {
        return this.title;
    }

    @Nullable
    public Component getControl() {
        return this.control;
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        AbstractHeaderPanel headerPanel = (AbstractHeaderPanel)parent;
        Dimension size = headerPanel.getSize();
        Insets insets = headerPanel.getInsets();
        boolean ltr = headerPanel.getComponentOrientation().isLeftToRight();
        int w = Math.max(0, size.width - insets.left - insets.right);
        int h = Math.max(0, size.height - insets.top - insets.bottom);
        Dimension cps = this.control != null ? this.control.getPreferredSize() : new Dimension(0, 0);
        switch (headerPanel.getHeaderPosition()) {
            case top: 
            case bottom: {
                if (this.title != null) {
                    this.title.setBounds(ltr ? insets.left : insets.left + cps.width, insets.top, w > cps.width ? w - cps.width : 0, h);
                }
                if (this.control == null) break;
                this.control.setBounds(ltr ? insets.left + w - cps.width : insets.left, insets.top, cps.width < w ? cps.width : w, h);
                break;
            }
            case left: {
                if (this.title != null) {
                    int th = h > cps.height ? h - cps.height : 0;
                    this.title.setBounds(insets.left, insets.top + cps.height, w, th);
                }
                if (this.control == null) break;
                int ch = cps.height < h ? cps.height : h;
                this.control.setBounds(insets.left, insets.top, w, ch);
                break;
            }
            case right: {
                if (this.title != null) {
                    int th = h > cps.height ? h - cps.height : 0;
                    this.title.setBounds(insets.left, insets.top, w, th);
                }
                if (this.control == null) break;
                int ch = cps.height < h ? cps.height : h;
                this.control.setBounds(insets.left, insets.top + h - ch, w, ch);
            }
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        AbstractHeaderPanel headerPanel = (AbstractHeaderPanel)parent;
        Dimension ps = new Dimension(0, 0);
        Dimension tps = this.title != null ? this.title.getPreferredSize() : new Dimension(0, 0);
        Dimension cps = this.control != null ? this.control.getPreferredSize() : new Dimension(0, 0);
        switch (headerPanel.getHeaderPosition()) {
            case top: 
            case bottom: {
                ps.width += tps.width + cps.width;
                ps.height += Math.max(tps.height, cps.height);
                break;
            }
            case left: 
            case right: {
                ps.width += Math.max(tps.width, cps.width);
                ps.height += tps.height + cps.height;
            }
        }
        Insets insets = headerPanel.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }
}

