/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.api.jdk.Objects;
import com.alee.extended.WebContainer;
import com.alee.extended.collapsible.AbstractControlButton;
import com.alee.extended.collapsible.AbstractHeaderPanel;
import com.alee.extended.collapsible.AbstractTitleLabel;
import com.alee.extended.collapsible.CollapsiblePaneLayout;
import com.alee.extended.collapsible.CollapsiblePaneListener;
import com.alee.extended.collapsible.WCollapsiblePaneUI;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public class WebCollapsiblePane
extends WebContainer<WebCollapsiblePane, WCollapsiblePaneUI> {
    public static final String HEADER_POSITION_PROPERTY = "headerPosition";
    public static final String HEADER_COMPONENT_PROPERTY = "headerComponent";
    public static final String TITLE_PROPERTY = "title";
    public static final String TITLE_COMPONENT_PROPERTY = "titleComponent";
    public static final String CONTROL_COMPONENT_PROPERTY = "controlComponent";
    public static final String CONTENT_PROPERTY = "content";
    public static final String ANIMATED_PROPERTY = "animated";
    public static final String EXPANDED_PROPERTY = "expanded";
    public static final String IN_TRANSITION_PROPERTY = "inTransition";
    @Nullable
    protected BoxOrientation headerPosition;
    @Nullable
    protected Component header;
    @Nullable
    protected Component title;
    @Nullable
    protected Component control;
    @Nullable
    protected Component content;
    @Nullable
    protected Boolean animated;
    protected boolean expanded;

    public WebCollapsiblePane() {
        this(StyleId.auto, null, null, null, true);
    }

    public WebCollapsiblePane(boolean expanded) {
        this(StyleId.auto, null, null, null, expanded);
    }

    public WebCollapsiblePane(@Nullable String title) {
        this(StyleId.auto, null, title, null, true);
    }

    public WebCollapsiblePane(@Nullable String title, boolean expanded) {
        this(StyleId.auto, null, title, null, expanded);
    }

    public WebCollapsiblePane(@Nullable Icon icon, @Nullable String title) {
        this(StyleId.auto, icon, title, null, true);
    }

    public WebCollapsiblePane(@Nullable Icon icon, @Nullable String title, boolean expanded) {
        this(StyleId.auto, icon, title, null, expanded);
    }

    public WebCollapsiblePane(@Nullable Component content) {
        this(StyleId.auto, null, null, content, true);
    }

    public WebCollapsiblePane(@Nullable Component content, boolean expanded) {
        this(StyleId.auto, null, null, content, expanded);
    }

    public WebCollapsiblePane(@Nullable String title, @Nullable Component content) {
        this(StyleId.auto, null, title, content, true);
    }

    public WebCollapsiblePane(@Nullable String title, @Nullable Component content, boolean expanded) {
        this(StyleId.auto, null, title, content, expanded);
    }

    public WebCollapsiblePane(@Nullable Icon icon, @Nullable String title, @Nullable Component content) {
        this(StyleId.auto, icon, title, content, true);
    }

    public WebCollapsiblePane(@Nullable Icon icon, @Nullable String title, @Nullable Component content, boolean expanded) {
        this(StyleId.auto, icon, title, content, expanded);
    }

    public WebCollapsiblePane(@NotNull StyleId id) {
        this(id, null, null, null, true);
    }

    public WebCollapsiblePane(@NotNull StyleId id, boolean expanded) {
        this(id, null, null, null, expanded);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable String title) {
        this(id, null, title, null, true);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable String title, boolean expanded) {
        this(id, null, title, null, expanded);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable Icon icon, @Nullable String title) {
        this(id, icon, title, null, true);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable Icon icon, @Nullable String title, boolean expanded) {
        this(id, icon, title, null, expanded);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable Component content) {
        this(id, null, null, content, true);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable Component content, boolean expanded) {
        this(id, null, null, content, expanded);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable String title, @Nullable Component content) {
        this(id, null, title, content, true);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable String title, @Nullable Component content, boolean expanded) {
        this(id, null, title, content, expanded);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable Icon icon, @Nullable String title, @Nullable Component content) {
        this(id, icon, title, content, true);
    }

    public WebCollapsiblePane(@NotNull StyleId id, @Nullable Icon icon, @Nullable String title, @Nullable Component content, boolean expanded) {
        this.updateUI();
        this.setIcon(icon);
        this.setTitle(title);
        this.setContent(content);
        this.setStyleId(id);
        this.setExpanded(expanded);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.collapsiblepane;
    }

    @Override
    @Nullable
    public CollapsiblePaneLayout getLayout() {
        return (CollapsiblePaneLayout)super.getLayout();
    }

    @Override
    public void setLayout(@Nullable LayoutManager layout) {
        if (layout == null || layout instanceof CollapsiblePaneLayout) {
            CollapsiblePaneLayout oldLayout = this.getLayout();
            if (oldLayout != null) {
                oldLayout.uninstall(this);
            }
            CollapsiblePaneLayout newLayout = (CollapsiblePaneLayout)layout;
            if (layout != null) {
                newLayout.install(this);
            }
        } else {
            throw new IllegalArgumentException("Only CollapsiblePaneLayout instances are supported");
        }
        super.setLayout(layout);
    }

    @NotNull
    public BoxOrientation getHeaderPosition() {
        return this.headerPosition != null ? this.headerPosition : BoxOrientation.top;
    }

    public void setHeaderPosition(@Nullable BoxOrientation position) {
        BoxOrientation headerPosition = this.getHeaderPosition();
        if (headerPosition != position) {
            this.headerPosition = position;
            this.firePropertyChange(HEADER_POSITION_PROPERTY, headerPosition, position);
        }
    }

    @NotNull
    public Component getHeaderComponent() {
        if (this.header == null) {
            this.setHeaderComponent(this.createHeaderComponent());
        }
        return this.header;
    }

    public void setHeaderComponent(@NotNull Component header) {
        if (this.header != header) {
            Component old = this.header;
            this.header = header;
            this.firePropertyChange(HEADER_COMPONENT_PROPERTY, old, header);
        }
    }

    @NotNull
    protected Component createHeaderComponent() {
        return new AbstractHeaderPanel.UIResource(){

            @Override
            @NotNull
            public BoxOrientation getHeaderPosition() {
                return WebCollapsiblePane.this.getHeaderPosition();
            }

            @Override
            public boolean isExpanded() {
                return WebCollapsiblePane.this.isExpanded();
            }

            @Override
            public boolean isInTransition() {
                return WebCollapsiblePane.this.isInTransition();
            }

            @Override
            protected void onHeaderAction(@NotNull InputEvent e) {
                WebCollapsiblePane.this.expandOrCollapse(e);
            }
        };
    }

    @Nullable
    public Icon getIcon() {
        return this.title instanceof AbstractTitleLabel ? ((AbstractTitleLabel)this.title).getIcon() : null;
    }

    public void setIcon(@Nullable Icon icon) {
        Component titleComponent = this.getTitleComponent();
        if (titleComponent instanceof AbstractTitleLabel) {
            AbstractTitleLabel titleLabel = (AbstractTitleLabel)titleComponent;
            Icon old = titleLabel.getIcon();
            titleLabel.setIcon(icon);
            this.firePropertyChange(TITLE_PROPERTY, old, titleComponent);
        }
    }

    @Nullable
    public String getTitle() {
        return this.title instanceof AbstractTitleLabel ? ((AbstractTitleLabel)this.title).getText() : null;
    }

    public void setTitle(@Nullable String title) {
        Component titleComponent = this.getTitleComponent();
        if (titleComponent instanceof AbstractTitleLabel) {
            AbstractTitleLabel titleLabel = (AbstractTitleLabel)titleComponent;
            String oldTitle = titleLabel.getText();
            titleLabel.setText(title);
            this.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
        }
    }

    @Nullable
    public Component getTitleComponent() {
        if (this.title == null) {
            this.setTitleComponent(this.createTitleComponent());
        }
        return this.title;
    }

    public void setTitleComponent(@Nullable Component title) {
        if (this.title != title) {
            Component oldTitle = this.title;
            this.title = title;
            this.firePropertyChange(TITLE_COMPONENT_PROPERTY, oldTitle, title);
        }
    }

    @Nullable
    protected Component createTitleComponent() {
        return new AbstractTitleLabel.UIResource(){

            @Override
            @NotNull
            public BoxOrientation getHeaderPosition() {
                return WebCollapsiblePane.this.getHeaderPosition();
            }

            @Override
            public boolean isExpanded() {
                return WebCollapsiblePane.this.isExpanded();
            }

            @Override
            public boolean isInTransition() {
                return WebCollapsiblePane.this.isInTransition();
            }
        };
    }

    @Nullable
    public Component getControlComponent() {
        if (this.control == null) {
            this.setControlComponent(this.createControlComponent());
        }
        return this.control;
    }

    public void setControlComponent(@Nullable Component control) {
        if (this.control != control) {
            Component old = this.control;
            this.control = control;
            this.firePropertyChange(CONTROL_COMPONENT_PROPERTY, old, control);
        }
    }

    @Nullable
    protected Component createControlComponent() {
        return new AbstractControlButton.UIResource(){

            @Override
            @NotNull
            public BoxOrientation getHeaderPosition() {
                return WebCollapsiblePane.this.getHeaderPosition();
            }

            @Override
            public boolean isExpanded() {
                return WebCollapsiblePane.this.isExpanded();
            }

            @Override
            public boolean isInTransition() {
                return WebCollapsiblePane.this.isInTransition();
            }

            @Override
            protected void onControlAction(@NotNull ActionEvent e) {
                WebCollapsiblePane.this.expandOrCollapse(e);
            }
        };
    }

    protected void expandOrCollapse(@NotNull AWTEvent e) {
        this.setExpanded(!this.isExpanded());
        if ((e instanceof MouseEvent || e instanceof ActionEvent) && this.isShowing() && this.isEnabled()) {
            if (this.isFocusable()) {
                this.requestFocusInWindow();
            } else {
                this.transferFocus();
            }
        }
    }

    @Nullable
    public Component getContent() {
        return this.content;
    }

    public void setContent(@Nullable Component content) {
        if (this.content != content) {
            Component old = this.content;
            this.content = content;
            this.firePropertyChange(CONTENT_PROPERTY, old, content);
        }
    }

    public boolean isAnimated() {
        return this.animated == null || this.animated != false;
    }

    public void setAnimated(boolean animated) {
        Boolean wasAnimated = this.animated;
        if (Objects.notEquals((Object)animated, (Object)wasAnimated)) {
            this.animated = animated;
            this.firePropertyChange(ANIMATED_PROPERTY, wasAnimated, (Object)animated);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            boolean old = this.expanded;
            this.expanded = expanded;
            this.firePropertyChange(EXPANDED_PROPERTY, old, expanded);
        }
    }

    public void expand() {
        this.setExpanded(true);
    }

    public void collapse() {
        this.setExpanded(false);
    }

    public boolean isInTransition() {
        return this.getLayout().isInTransition();
    }

    public void addCollapsiblePaneListener(@NotNull CollapsiblePaneListener listener) {
        this.listenerList.add(CollapsiblePaneListener.class, listener);
    }

    public void removeCollapsiblePaneListener(@NotNull CollapsiblePaneListener listener) {
        this.listenerList.remove(CollapsiblePaneListener.class, listener);
    }

    public void fireExpanding() {
        for (CollapsiblePaneListener listener : (CollapsiblePaneListener[])this.listenerList.getListeners(CollapsiblePaneListener.class)) {
            listener.expanding(this);
        }
    }

    public void fireExpanded() {
        for (CollapsiblePaneListener listener : (CollapsiblePaneListener[])this.listenerList.getListeners(CollapsiblePaneListener.class)) {
            listener.expanded(this);
        }
    }

    public void fireCollapsing() {
        for (CollapsiblePaneListener listener : (CollapsiblePaneListener[])this.listenerList.getListeners(CollapsiblePaneListener.class)) {
            listener.collapsing(this);
        }
    }

    public void fireCollapsed() {
        for (CollapsiblePaneListener listener : (CollapsiblePaneListener[])this.listenerList.getListeners(CollapsiblePaneListener.class)) {
            listener.collapsed(this);
        }
    }

    @Override
    public WCollapsiblePaneUI getUI() {
        return (WCollapsiblePaneUI)this.ui;
    }

    public void setUI(WCollapsiblePaneUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

