/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.colorchooser.DoubleColorFieldListener;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LM;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageListener;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ColorUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DoubleColorField
extends WebPanel {
    private final List<DoubleColorFieldListener> listeners = new ArrayList<DoubleColorFieldListener>(1);
    @Nullable
    private Color newColor;
    @Nullable
    private HSBColor newHSBColor;
    @Nullable
    private Color oldColor;
    @Nullable
    private HSBColor oldHSBColor;

    public DoubleColorField() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getY() <= DoubleColorField.this.getHeight() / 2) {
                        DoubleColorField.this.newColorPressed();
                    } else {
                        DoubleColorField.this.oldColorPressed();
                    }
                }
            }
        });
        this.addLanguageListener(new LanguageListener(){

            public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                DoubleColorField.this.revalidate();
                DoubleColorField.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Map hints = SwingUtils.setupTextAntialias(g2d);
        g2d.setPaint(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setPaint(Color.GRAY);
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g2d.setPaint(Color.WHITE);
        g2d.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
        g2d.drawLine(1, this.getHeight() / 2, this.getWidth() - 3, this.getHeight() / 2);
        this.paintColorRectangle(g2d, new Rectangle(2, 2, this.getWidth() - 5, this.getHeight() / 2 - 3), this.newColor, this.newHSBColor, LM.get((String)"weblaf.colorchooser.color.new", (Object[])new Object[0]));
        this.paintColorRectangle(g2d, new Rectangle(2, this.getHeight() / 2 + 1, this.getWidth() - 5, this.getHeight() / 2 - 4), this.oldColor, this.oldHSBColor, LM.get((String)"weblaf.colorchooser.color.current", (Object[])new Object[0]));
        SwingUtils.restoreTextAntialias(g2d, hints);
    }

    private void paintColorRectangle(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @Nullable Color color, @Nullable HSBColor hsbColor, @NotNull String text) {
        boolean newColorIsLight;
        FontMetrics fm = g2d.getFontMetrics();
        if (color != null) {
            g2d.setPaint(color);
            g2d.fillRect(bounds.x, bounds.y, bounds.width + 1, bounds.height + 1);
        } else {
            g2d.setPaint(Color.GRAY);
            g2d.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
            g2d.drawLine(bounds.x + bounds.width, bounds.y, bounds.x, bounds.y + bounds.height);
        }
        Point nts = LafUtils.getTextCenterShift(fm, text);
        boolean bl = newColorIsLight = hsbColor == null || hsbColor.getBrightness() >= 0.7f && hsbColor.getSaturation() < 0.7f;
        if (color == null) {
            int fw = fm.stringWidth(text);
            int fh = fm.getHeight();
            g2d.setPaint(new RadialGradientPaint(bounds.x + bounds.width / 2, (float)(bounds.y + bounds.height / 2), bounds.width / 2, new float[]{0.0f, 1.0f}, new Color[]{this.getBackground(), ColorUtils.transparent()}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
            g2d.fillRect(bounds.x + bounds.width / 2 - fw / 2, bounds.y + bounds.height / 2 - fh / 2 + 1, fw, fh);
        }
        g2d.setPaint(newColorIsLight ? Color.BLACK : Color.WHITE);
        g2d.drawString(text, bounds.x + bounds.width / 2 + nts.x, bounds.y + bounds.height / 2 + nts.y);
    }

    @Nullable
    public Color getNewColor() {
        return this.newColor;
    }

    public void setNewColor(@Nullable Color newColor) {
        this.newColor = newColor;
        this.newHSBColor = newColor != null ? new HSBColor(newColor) : null;
        this.repaint();
    }

    @Nullable
    public Color getOldColor() {
        return this.oldColor;
    }

    public void setOldColor(@Nullable Color oldColor) {
        this.oldColor = oldColor;
        this.oldHSBColor = oldColor != null ? new HSBColor(oldColor) : null;
        this.repaint();
    }

    public void addDoubleColorFieldListener(DoubleColorFieldListener listener) {
        this.listeners.add(listener);
    }

    public void removeDoubleColorFieldListener(DoubleColorFieldListener listener) {
        this.listeners.remove(listener);
    }

    private void newColorPressed() {
        for (DoubleColorFieldListener listener : CollectionUtils.copy(this.listeners)) {
            listener.newColorPressed(this.newColor);
        }
    }

    private void oldColorPressed() {
        for (DoubleColorFieldListener listener : CollectionUtils.copy(this.listeners)) {
            listener.oldColorPressed(this.oldColor);
        }
    }
}

