/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.laf.WebLookAndFeel;
import com.alee.utils.CollectionUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WebColorPicker
extends JComponent {
    public static final ImageIcon DEFAULT_ICON = new ImageIcon(WebColorPicker.class.getResource("icons/default.png"));
    public static final ImageIcon SWITCH_ICON = new ImageIcon(WebColorPicker.class.getResource("icons/switch.png"));
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>(1);
    private static final int RECT_LENGTH = 28;
    private Color border1color = new Color(192, 192, 192);
    private Color border2color = Color.WHITE;
    private Color color1 = Color.BLACK;
    private Color color2 = Color.WHITE;
    private PickerPart lastPickerPart = PickerPart.colorSwitch;

    public WebColorPicker() {
        WebLookAndFeel.setOrientation(this);
        this.setPreferredSize(new Dimension(44, 44));
        this.initListeners();
    }

    public Color getColor() {
        return this.color1;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
        this.repaint();
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
        this.repaint();
    }

    private void initListeners() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Color color;
                if (WebColorPicker.this.isSwitchUnderPoint(e)) {
                    WebColorPicker.this.switchColors();
                } else if (WebColorPicker.this.isDefaultUnderPoint(e)) {
                    WebColorPicker.this.setDefaultColors();
                } else if (SwingUtilities.isLeftMouseButton(e) && WebColorPicker.this.isColor1UnderPoint(e)) {
                    Color color2 = JColorChooser.showDialog(null, "Primary color chooser", WebColorPicker.this.color1);
                    if (color2 != null) {
                        WebColorPicker.this.color1 = color2;
                        WebColorPicker.this.repaint();
                        WebColorPicker.this.fireActionPerformed();
                    }
                } else if (SwingUtilities.isLeftMouseButton(e) && WebColorPicker.this.isColor2UnderPoint(e) && (color = JColorChooser.showDialog(null, "Secondary color chooser", WebColorPicker.this.color2)) != null) {
                    WebColorPicker.this.color2 = color;
                    WebColorPicker.this.repaint();
                    WebColorPicker.this.fireActionPerformed();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateTT(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.updateTT(e);
            }

            private void updateTT(MouseEvent e) {
                if (WebColorPicker.this.isSwitchUnderPoint(e)) {
                    WebColorPicker.this.updateToolTip(PickerPart.colorSwitch);
                } else if (WebColorPicker.this.isDefaultUnderPoint(e)) {
                    WebColorPicker.this.updateToolTip(PickerPart.defaultColor);
                } else if (WebColorPicker.this.isColor1UnderPoint(e)) {
                    WebColorPicker.this.updateToolTip(PickerPart.color1);
                } else if (WebColorPicker.this.isColor2UnderPoint(e)) {
                    WebColorPicker.this.updateToolTip(PickerPart.color2);
                } else {
                    WebColorPicker.this.updateToolTip(null);
                }
            }
        };
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    private void updateToolTip(PickerPart pickerPart) {
        if (pickerPart != this.lastPickerPart) {
            this.setToolTip(pickerPart);
            this.lastPickerPart = pickerPart;
        }
    }

    public void setToolTip(PickerPart pickerPart) {
        if (pickerPart == null) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("Switch primary and secondary colors");
        }
    }

    public void switchColors() {
        Color tmp = this.color2;
        this.color2 = this.color1;
        this.color1 = tmp;
        this.repaint();
        this.fireActionPerformed();
    }

    public void setDefaultColors() {
        this.color1 = Color.BLACK;
        this.color2 = Color.WHITE;
        this.repaint();
        this.fireActionPerformed();
    }

    private boolean isColor2UnderPoint(MouseEvent e) {
        return (e.getX() > 30 || e.getY() > 30) && e.getX() >= this.getWidth() - 1 - 28 && e.getX() <= this.getWidth() - 5 && e.getY() >= this.getHeight() - 1 - 28 && e.getY() <= this.getHeight() - 5;
    }

    private boolean isColor1UnderPoint(MouseEvent e) {
        return e.getX() >= 4 && e.getX() <= 28 && e.getY() >= 4 && e.getY() <= 28;
    }

    private boolean isDefaultUnderPoint(MouseEvent e) {
        return e.getX() >= 1 && e.getX() <= 1 + DEFAULT_ICON.getIconWidth() && e.getY() >= this.getHeight() - DEFAULT_ICON.getIconHeight() - 1 && e.getY() <= this.getHeight() - 1;
    }

    private boolean isSwitchUnderPoint(MouseEvent e) {
        return e.getX() >= this.getWidth() - SWITCH_ICON.getIconWidth() - 1 && e.getX() <= this.getWidth() - 1 && e.getY() >= 1 && e.getY() <= 1 + SWITCH_ICON.getIconHeight();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isEnabled()) {
            g.setXORMode(Color.GRAY);
        }
        g.setColor(this.border1color);
        g.drawRect(this.getWidth() - 3 - 28, this.getHeight() - 3 - 28, 28, 28);
        g.setColor(this.border2color);
        g.drawRect(this.getWidth() - 2 - 28, this.getHeight() - 2 - 28, 26, 26);
        g.setColor(this.color2);
        g.fillRect(this.getWidth() - 1 - 28, this.getHeight() - 1 - 28, 25, 25);
        g.setColor(this.border1color);
        g.drawRect(2, 2, 28, 28);
        g.setColor(this.border2color);
        g.drawRect(3, 3, 26, 26);
        g.setColor(this.color1);
        g.fillRect(4, 4, 25, 25);
        if (!this.isEnabled()) {
            g.setPaintMode();
        }
        g.drawImage(SWITCH_ICON.getImage(), this.getWidth() - SWITCH_ICON.getIconWidth() - 1, 1, SWITCH_ICON.getImageObserver());
        g.drawImage(DEFAULT_ICON.getImage(), 1, this.getHeight() - DEFAULT_ICON.getIconHeight() - 1, DEFAULT_ICON.getImageObserver());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.repaint();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Color changed");
        for (ActionListener actionListener : CollectionUtils.copy(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public static enum PickerPart {
        colorSwitch,
        defaultColor,
        color1,
        color2;

    }
}

