/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.dock.SidebarButtonAction;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.WebDockablePane;
import com.alee.laf.button.WebToggleButton;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class SidebarButton
extends WebToggleButton
implements Stateful {
    protected final WebDockableFrame frame;

    public SidebarButton(final @NotNull WebDockableFrame frame) {
        super(StyleId.dockableframeSidebarButton.at(frame), frame.getTitle(), frame.getIcon());
        this.frame = frame;
        this.setFocusable(false);
        this.setSelected(this.getSelectionState());
        this.onMousePress(MouseButton.right, new MouseEventRunnable(){

            @Override
            public void run(@NotNull MouseEvent e) {
                WebDockablePane dockablePane = frame.getDockablePane();
                if (dockablePane != null) {
                    if (dockablePane.getSidebarButtonAction() == SidebarButtonAction.preview) {
                        if (frame.isMinimized()) {
                            frame.dock();
                        } else {
                            frame.minimize();
                        }
                    } else if (frame.isMinimized()) {
                        frame.preview();
                    } else if (frame.isPreview()) {
                        frame.minimize();
                    }
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebDockablePane dockablePane = frame.getDockablePane();
                if (dockablePane != null) {
                    if (SidebarButton.this.isSelected()) {
                        switch (dockablePane.getSidebarButtonAction()) {
                            case restore: {
                                frame.restore();
                                break;
                            }
                            case preview: {
                                frame.preview();
                                break;
                            }
                            case dock: {
                                frame.dock();
                                break;
                            }
                            case detach: {
                                frame.detach();
                            }
                        }
                    } else {
                        frame.minimize();
                    }
                }
            }
        });
    }

    public WebDockableFrame getFrame() {
        return this.frame;
    }

    @Override
    @Nullable
    public List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>();
        if (this.frame != null) {
            states.add(this.frame.getState().name());
            states.add(this.frame.getPosition().name());
        }
        return states;
    }

    public void updateStates() {
        boolean selected = this.getSelectionState();
        if (selected != this.isSelected()) {
            this.setSelected(selected);
        }
        DecorationUtils.fireStatesChanged(this);
    }

    protected boolean getSelectionState() {
        return this.frame.isDocked() || this.frame.isFloating() || this.frame.isPreview() && this.frame.getDockablePane() != null && this.frame.getDockablePane().getSidebarButtonAction() == SidebarButtonAction.preview;
    }
}

