/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Objects;
import com.alee.extended.WebContainer;
import com.alee.extended.dock.DockableFrameListener;
import com.alee.extended.dock.DockableFrameState;
import com.alee.extended.dock.SidebarButton;
import com.alee.extended.dock.WDockableFrameUI;
import com.alee.extended.dock.WebDockablePane;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.CollectionUtils;
import java.awt.ComponentOrientation;
import java.util.List;
import javax.swing.Icon;

public class WebDockableFrame
extends WebContainer<WebDockableFrame, WDockableFrameUI>
implements Identifiable,
Stateful {
    public static final String FRAME_ID_PROPERTY = "frameId";
    public static final String STATE_PROPERTY = "state";
    public static final String MAXIMIZED_PROPERTY = "maximized";
    public static final String RESTORE_STATE_PROPERTY = "restoreState";
    public static final String DRAGGABLE_PROPERTY = "draggable";
    public static final String FLOATABLE_PROPERTY = "floatable";
    public static final String MAXIMIZABLE_PROPERTY = "maximizable";
    public static final String CLOSABLE_PROPERTY = "closable";
    public static final String ICON_PROPERTY = "icon";
    public static final String TITLE_PROPERTY = "title";
    public static final String POSITION_PROPERTY = "position";
    public static final String DOCKABLE_PANE_PROPERTY = "dockablePane";
    @NotNull
    protected String frameId;
    @NotNull
    protected DockableFrameState state;
    protected boolean maximized;
    @NotNull
    protected DockableFrameState restoreState;
    @NotNull
    protected CompassDirection position;
    @Nullable
    protected Icon icon;
    @Nullable
    protected String title;
    protected boolean draggable;
    protected boolean floatable;
    protected boolean maximizable;
    protected boolean closable;
    @Nullable
    protected WebDockablePane dockablePane;

    public WebDockableFrame(@NotNull String frameId, @Nullable String title) {
        this(StyleId.auto, frameId, null, title);
    }

    public WebDockableFrame(@NotNull String frameId, @Nullable Icon icon) {
        this(StyleId.auto, frameId, icon, null);
    }

    public WebDockableFrame(@NotNull String frameId, @Nullable Icon icon, @Nullable String title) {
        this(StyleId.auto, frameId, icon, title);
    }

    public WebDockableFrame(@NotNull StyleId id, @NotNull String frameId, @Nullable String title) {
        this(id, frameId, null, title);
    }

    public WebDockableFrame(@NotNull StyleId id, @NotNull String frameId, @Nullable Icon icon) {
        this(id, frameId, icon, null);
    }

    public WebDockableFrame(@NotNull StyleId id, @NotNull String frameId, @Nullable Icon icon, @Nullable String title) {
        this.frameId = frameId;
        this.icon = icon;
        this.title = title;
        this.state = DockableFrameState.docked;
        this.maximized = false;
        this.restoreState = DockableFrameState.docked;
        this.position = CompassDirection.west;
        this.draggable = true;
        this.closable = true;
        this.floatable = true;
        this.maximizable = true;
        this.setFocusCycleRoot(true);
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.dockableframe;
    }

    @NotNull
    public String getId() {
        return this.frameId;
    }

    @NotNull
    public WebDockableFrame setId(@NotNull String id) {
        if (Objects.notEquals((Object)this.frameId, (Object)id)) {
            String old = this.frameId;
            this.frameId = id;
            this.firePropertyChange(FRAME_ID_PROPERTY, old, id);
        }
        return this;
    }

    @Override
    @Nullable
    public List<String> getStates() {
        return CollectionUtils.asList((Object[])new String[]{this.getState().name()});
    }

    @NotNull
    public DockableFrameState getState() {
        return this.state;
    }

    @NotNull
    public WebDockableFrame setState(@NotNull DockableFrameState state) {
        if (this.state != state) {
            DockableFrameState old = this.state;
            this.state = state;
            this.firePropertyChange(STATE_PROPERTY, (Object)old, (Object)state);
        }
        return this;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    @NotNull
    public WebDockableFrame setMaximized(boolean maximized) {
        if (Objects.notEquals((Object)this.maximized, (Object)maximized)) {
            boolean old = this.maximized;
            this.maximized = maximized;
            this.firePropertyChange(MAXIMIZED_PROPERTY, old, maximized);
        }
        return this;
    }

    @NotNull
    public DockableFrameState getRestoreState() {
        return this.restoreState;
    }

    @NotNull
    public WebDockableFrame setRestoreState(@NotNull DockableFrameState state) {
        if (this.restoreState != state) {
            DockableFrameState old = this.restoreState;
            this.restoreState = state;
            this.firePropertyChange(RESTORE_STATE_PROPERTY, (Object)old, (Object)state);
        }
        return this;
    }

    @NotNull
    public CompassDirection getPosition() {
        return this.position;
    }

    @NotNull
    public WebDockableFrame setPosition(@NotNull CompassDirection position) {
        if (this.position != position) {
            CompassDirection old = this.position;
            this.position = position;
            this.firePropertyChange(POSITION_PROPERTY, old, position);
        }
        return this;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public WebDockableFrame setIcon(@Nullable Icon icon) {
        if (this.icon != icon) {
            Icon old = this.icon;
            this.icon = icon;
            this.firePropertyChange(ICON_PROPERTY, old, icon);
        }
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public WebDockableFrame setTitle(@Nullable String title) {
        if (Objects.notEquals((Object)this.title, (Object)title)) {
            String old = this.title;
            this.title = title;
            this.firePropertyChange(TITLE_PROPERTY, old, title);
        }
        return this;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    @NotNull
    public WebDockableFrame setDraggable(boolean draggable) {
        if (this.draggable != draggable) {
            boolean old = this.draggable;
            this.draggable = draggable;
            this.firePropertyChange(DRAGGABLE_PROPERTY, old, draggable);
        }
        return this;
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    @NotNull
    public WebDockableFrame setFloatable(boolean floatable) {
        if (this.floatable != floatable) {
            boolean old = this.floatable;
            this.floatable = floatable;
            this.firePropertyChange(FLOATABLE_PROPERTY, old, floatable);
        }
        return this;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    @NotNull
    public WebDockableFrame setMaximizable(boolean maximizable) {
        if (this.maximizable != maximizable) {
            boolean old = this.maximizable;
            this.maximizable = maximizable;
            this.firePropertyChange(MAXIMIZABLE_PROPERTY, old, maximizable);
        }
        return this;
    }

    public boolean isClosable() {
        return this.closable;
    }

    @NotNull
    public WebDockableFrame setClosable(boolean closable) {
        if (this.closable != closable) {
            boolean old = this.closable;
            this.closable = closable;
            this.firePropertyChange(CLOSABLE_PROPERTY, old, closable);
        }
        return this;
    }

    @Nullable
    public WebDockablePane getDockablePane() {
        return this.dockablePane;
    }

    @NotNull
    protected WebDockableFrame setDockablePane(@Nullable WebDockablePane dockablePane) {
        if (this.dockablePane != dockablePane) {
            WebDockablePane old = this.dockablePane;
            this.dockablePane = dockablePane;
            this.firePropertyChange(DOCKABLE_PANE_PROPERTY, old, dockablePane);
        }
        return this;
    }

    @NotNull
    public SidebarButton getSidebarButton() {
        return this.getUI().getSidebarButton();
    }

    public boolean isSidebarButtonVisible() {
        boolean visible = false;
        WebDockablePane dockablePane = this.getDockablePane();
        if (dockablePane != null) {
            block0 : switch (dockablePane.getSidebarButtonVisibility()) {
                case never: {
                    visible = false;
                    break;
                }
                case minimized: {
                    visible = this.isMinimized() || this.isPreview();
                    break;
                }
                case anyMinimized: {
                    if (this.isClosed()) break;
                    for (WebDockableFrame frame : dockablePane.getFrames(this.getPosition())) {
                        if (!frame.isMinimized() && !frame.isPreview()) continue;
                        visible = true;
                        break block0;
                    }
                    break;
                }
                case always: {
                    visible = this.isOpened();
                }
            }
        }
        return visible;
    }

    public boolean isClosed() {
        return this.state == DockableFrameState.closed;
    }

    public boolean isOpened() {
        return this.state != DockableFrameState.closed;
    }

    public boolean isMinimized() {
        return this.state == DockableFrameState.minimized;
    }

    public boolean isPreview() {
        return this.state == DockableFrameState.preview;
    }

    public boolean isDocked() {
        return this.state == DockableFrameState.docked;
    }

    public boolean isFloating() {
        return this.state == DockableFrameState.floating;
    }

    @NotNull
    public WebDockableFrame minimize() {
        return this.setState(DockableFrameState.minimized);
    }

    @NotNull
    public WebDockableFrame dock() {
        return this.setState(DockableFrameState.docked);
    }

    @NotNull
    public WebDockableFrame preview() {
        return this.setState(DockableFrameState.preview);
    }

    @NotNull
    public WebDockableFrame detach() {
        return this.setState(DockableFrameState.floating);
    }

    public void maximize() {
        if (!this.isMaximized()) {
            if (!this.isDocked() && !this.isFloating()) {
                this.restore();
            }
            this.setMaximized(true);
        } else {
            this.setMaximized(false);
        }
    }

    @NotNull
    public WebDockableFrame restore() {
        return this.setState(this.getRestoreState());
    }

    @NotNull
    public WebDockableFrame close() {
        return this.setState(DockableFrameState.closed);
    }

    public void addFrameListener(@NotNull DockableFrameListener listener) {
        this.listenerList.add(DockableFrameListener.class, listener);
    }

    public void removeFrameListener(@NotNull DockableFrameListener listener) {
        this.listenerList.remove(DockableFrameListener.class, listener);
    }

    public void fireFrameAdded() {
        WebDockablePane dockablePane = this.getDockablePane();
        if (dockablePane != null) {
            for (DockableFrameListener listener : (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class)) {
                listener.frameAdded(this, dockablePane);
            }
        }
    }

    public void fireFrameStateChanged(@NotNull DockableFrameState oldState, @NotNull DockableFrameState newState) {
        for (DockableFrameListener listener : (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class)) {
            listener.frameStateChanged(this, oldState, newState);
        }
    }

    public void fireFrameMoved(@NotNull CompassDirection position) {
        for (DockableFrameListener listener : (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class)) {
            listener.frameMoved(this, position);
        }
    }

    public void fireFrameRemoved() {
        WebDockablePane dockablePane = this.getDockablePane();
        if (dockablePane != null) {
            for (DockableFrameListener listener : (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class)) {
                listener.frameRemoved(this, dockablePane);
            }
        }
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation orientation) {
        super.applyComponentOrientation(orientation);
        this.getSidebarButton().applyComponentOrientation(orientation);
    }

    @Override
    public WDockableFrameUI getUI() {
        return (WDockableFrameUI)this.ui;
    }

    public void setUI(WDockableFrameUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

