/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.dock.DockableFrameState;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.dock.data.AbstractDockableElement;
import com.alee.extended.dock.data.ResizeData;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.xml.RectangleConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;

@XStreamAlias(value="DockableFrame")
public class DockableFrameElement
extends AbstractDockableElement {
    @XStreamAsAttribute
    @NotNull
    protected DockableFrameState state;
    @XStreamAsAttribute
    @NotNull
    protected DockableFrameState restoreState;
    @XStreamAsAttribute
    @XStreamConverter(value=RectangleConverter.class)
    @Nullable
    protected Rectangle floatingBounds;

    public DockableFrameElement(@NotNull WebDockableFrame frame) {
        this(frame.getId(), frame.getState(), frame.getRestoreState(), frame.getPreferredSize());
    }

    public DockableFrameElement(@NotNull WebDockableFrame frame, @NotNull DockableFrameState state) {
        this(frame.getId(), state, state, frame.getPreferredSize());
    }

    public DockableFrameElement(@NotNull WebDockableFrame frame, @NotNull Dimension size) {
        this(frame.getId(), frame.getState(), frame.getRestoreState(), size);
    }

    public DockableFrameElement(@NotNull WebDockableFrame frame, @NotNull DockableFrameState state, @NotNull Dimension size) {
        this(frame.getId(), state, state, size);
    }

    public DockableFrameElement(@NotNull String id, @NotNull DockableFrameState state, @NotNull Dimension size) {
        this(id, state, state, size);
    }

    public DockableFrameElement(@NotNull String id, @NotNull DockableFrameState state, @NotNull DockableFrameState restoreState, @NotNull Dimension size) {
        super(id, size);
        this.state = state;
        this.restoreState = restoreState;
        this.floatingBounds = null;
    }

    @NotNull
    public DockableFrameState getState() {
        return this.state;
    }

    public void setState(@NotNull DockableFrameState state) {
        this.state = state;
    }

    @NotNull
    public DockableFrameState getRestoreState() {
        return this.restoreState;
    }

    public void setRestoreState(@NotNull DockableFrameState state) {
        this.restoreState = state;
    }

    @Nullable
    public Rectangle getFloatingBounds() {
        return this.floatingBounds;
    }

    public void setFloatingBounds(@Nullable Rectangle bounds) {
        this.floatingBounds = bounds;
    }

    public void saveFloatingBounds(@NotNull WebDockableFrame frame) {
        Rectangle bounds = CoreSwingUtils.getBoundsOnScreen((Component)frame, (boolean)false);
        this.setFloatingBounds(bounds);
    }

    @Override
    public boolean isContent() {
        return false;
    }

    @Override
    public boolean isVisible(@NotNull WebDockablePane dockablePane) {
        WebDockableFrame frame = dockablePane.findFrame(this.getId());
        return frame != null && frame.isDocked();
    }

    @Override
    public void layout(@NotNull WebDockablePane dockablePane, @NotNull Rectangle bounds, @NotNull List<ResizeData> resizeableAreas) {
        this.setBounds(bounds);
        dockablePane.getFrame(this.getId()).setBounds(bounds);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@NotNull WebDockablePane dockablePane) {
        Dimension min = dockablePane.getMinimumElementSize();
        if (this.size.width < min.width || this.size.height < min.height) {
            this.setSize(new Dimension(Math.max(this.size.width, min.width), Math.max(this.size.height, min.height)));
        }
        return min;
    }
}

