/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.hotkey;

import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LM;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class WebHotkeyField
extends WebTextField {
    private static final String EMPTY_HOTKEY_TEXT_KEY = "weblaf.ex.hotkeyfield.press";
    private final List<Integer> keys = new ArrayList<Integer>();
    private boolean isCtrl = false;
    private boolean isAlt = false;
    private boolean isShift = false;
    private Integer keyCode = null;

    public WebHotkeyField() {
        this.updateFieldText();
        this.setEditable(false);
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(0);
        this.setSelectionColor(this.getBackground());
        this.setSelectedTextColor(this.getForeground());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (WebHotkeyField.this.keys.size() == 0) {
                    WebHotkeyField.this.clearData();
                }
                WebHotkeyField.this.keys.add(e.getKeyCode());
                this.updateKeys(e);
                WebHotkeyField.this.updateFieldText();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                WebHotkeyField.this.keys.remove((Object)e.getKeyCode());
                WebHotkeyField.this.updateFieldText();
            }

            private void updateKeys(KeyEvent e) {
                WebHotkeyField.this.isCtrl = SwingUtils.isCtrl(e);
                WebHotkeyField.this.isAlt = SwingUtils.isAlt(e);
                WebHotkeyField.this.isShift = SwingUtils.isShift(e);
                if (e.getKeyCode() != 17 && e.getKeyCode() != 18 && e.getKeyCode() != 16) {
                    WebHotkeyField.this.keyCode = e.getKeyCode();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (WebHotkeyField.this.isEnabled() && SwingUtils.isDoubleClick(e)) {
                    WebHotkeyField.this.clearData();
                    WebHotkeyField.this.updateFieldText();
                }
            }
        });
    }

    public void updateFieldText() {
        this.setText(this.isEmpty() ? LM.get((String)EMPTY_HOTKEY_TEXT_KEY, (Object[])new Object[0]) : this.getHotkeyData().toString());
    }

    @Override
    public boolean isEmpty() {
        return this.keyCode == null && (!this.isCtrl && !this.isAlt && !this.isShift || this.keys.size() == 0);
    }

    public boolean isCtrl() {
        return this.isCtrl;
    }

    public void setCtrl(boolean ctrl) {
        this.isCtrl = ctrl;
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public void setAlt(boolean alt) {
        this.isAlt = alt;
    }

    public boolean isShift() {
        return this.isShift;
    }

    public void setShift(boolean shift) {
        this.isShift = shift;
    }

    public Integer getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(Integer keyCode) {
        this.keyCode = keyCode;
        this.updateFieldText();
    }

    public HotkeyData getHotkeyData() {
        return new HotkeyData(this.isCtrl(), this.isAlt(), this.isShift(), this.getKeyCode());
    }

    public void setHotkeyData(HotkeyData hotkeyData) {
        this.setCtrl(hotkeyData.isCtrl());
        this.setAlt(hotkeyData.isAlt());
        this.setShift(hotkeyData.isShift());
        this.setKeyCode(hotkeyData.getKeyCode());
    }

    public void clearData() {
        this.keyCode = null;
        this.isCtrl = false;
        this.isAlt = false;
        this.isShift = false;
    }
}

