/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.inspector.ComponentHighlighter;
import com.alee.extended.inspector.InterfaceTree;
import com.alee.extended.inspector.InterfaceTreeNode;
import com.alee.extended.inspector.InterfaceTreeNodeComparator;
import com.alee.extended.tree.AbstractExTreeDataProvider;
import com.alee.utils.compare.Filter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.CellRendererPane;

public class InterfaceTreeDataProvider
extends AbstractExTreeDataProvider<InterfaceTreeNode>
implements Filter<Component> {
    @NotNull
    protected final InterfaceTree tree;
    @Nullable
    protected final Component inspected;

    public InterfaceTreeDataProvider(@NotNull InterfaceTree tree, @Nullable Component inspected) {
        this.tree = tree;
        this.inspected = inspected;
        this.setChildrenComparator(new InterfaceTreeNodeComparator());
    }

    @Override
    @NotNull
    public InterfaceTreeNode getRoot() {
        return new InterfaceTreeNode(this.tree, this.inspected);
    }

    @Override
    @NotNull
    public List<InterfaceTreeNode> getChildren(@NotNull InterfaceTreeNode parent) {
        ArrayList<InterfaceTreeNode> nodes;
        Component component = (Component)parent.getUserObject();
        if (component == null) {
            Window[] windows = Window.getWindows();
            nodes = new ArrayList<InterfaceTreeNode>(windows.length);
            for (Window window : windows) {
                if (!window.isShowing()) continue;
                nodes.add(new InterfaceTreeNode(this.tree, window));
            }
        } else if (component instanceof Container && !(component instanceof CellRendererPane)) {
            Container container = (Container)component;
            nodes = new ArrayList(container.getComponentCount());
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component child = container.getComponent(i);
                if (!this.accept(child)) continue;
                nodes.add(new InterfaceTreeNode(this.tree, child));
            }
        } else {
            nodes = new ArrayList(0);
        }
        return nodes;
    }

    public boolean accept(@Nullable Component component) {
        return !(component instanceof ComponentHighlighter);
    }
}

