/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector.info;

import com.alee.api.annotations.NotNull;
import com.alee.extended.inspector.info.AbstractComponentPreview;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;

public class WComponentPreview<C extends JComponent>
extends AbstractComponentPreview<C> {
    @Override
    @NotNull
    public Icon getIconImpl(@NotNull C component) {
        JRootPane rootPane = CoreSwingUtils.getRootPane(component);
        Icon icon = rootPane != null && rootPane.getGlassPane() == component ? glassPaneType : StyleManager.getDescriptor(component).getIcon();
        return icon;
    }

    @Override
    @NotNull
    public String getText(@NotNull C component) {
        String title = "{" + ReflectUtils.getCompleteClassName(component.getClass()) + ":c(" + this.getTitleColor(component) + ")}";
        LayoutManager layoutManager = ((Container)component).getLayout();
        String layout = this.renderLayout(layoutManager);
        boolean wlui = LafUtils.hasWebLafUI(component);
        String style = wlui ? " {[ " + StyleId.get(component).getCompleteId() + " ]:b;c(" + "30,110,30" + ")}" : "";
        Insets margin = PainterSupport.getMargin(component);
        String mtext = this.renderInsets(margin, "190,190,0");
        Insets padding = PainterSupport.getPadding(component);
        String ptext = this.renderInsets(padding, "0,150,70");
        return title + layout + style + mtext + ptext;
    }
}

