/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.MergeBehavior;
import com.alee.api.merge.RecursiveMerge;
import com.alee.api.merge.behavior.PreserveOnMerge;
import com.alee.extended.label.CustomStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import java.awt.Color;
import java.util.List;

public class StyleRange
implements MergeBehavior<StyleRange>,
Cloneable {
    protected final int startIndex;
    protected final int length;
    @Nullable
    protected final Color foreground;
    @Nullable
    protected final Color background;
    @PreserveOnMerge
    protected final int style;
    @NotNull
    protected final List<CustomStyle> customStyles;

    public StyleRange(@NotNull StyleRange styleRange) {
        this(styleRange, styleRange.getStartIndex(), styleRange.getLength());
    }

    public StyleRange(@NotNull StyleRange styleRange, int startIndex, int length) {
        this(startIndex, length, styleRange.getStyle(), styleRange.getForeground(), styleRange.getBackground(), CollectionUtils.copy(styleRange.getCustomStyle()));
    }

    public StyleRange(int startIndex, int length, CustomStyle ... customStyles) {
        this(startIndex, length, -1, (Color)null, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, int style, CustomStyle ... customStyles) {
        this(startIndex, length, style, (Color)null, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, @Nullable Color foreground, CustomStyle ... customStyles) {
        this(startIndex, length, -1, foreground, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, @Nullable Color foreground, Color background, CustomStyle ... customStyles) {
        this(startIndex, length, -1, foreground, background, customStyles);
    }

    public StyleRange(int startIndex, int length, int style, @Nullable Color foreground, CustomStyle ... customStyles) {
        this(startIndex, length, style, foreground, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, int style, @Nullable Color foreground, @Nullable Color background, CustomStyle ... customStyles) {
        this(startIndex, length, style, foreground, background, CollectionUtils.asList((Object[])customStyles));
    }

    public StyleRange(int startIndex, int length, int style, @Nullable Color foreground, @Nullable Color background, @NotNull List<CustomStyle> customStyles) {
        if (startIndex < 0) {
            throw new IllegalArgumentException("Style start index cannot be less than zero");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Style length cannot be zero or less than zero");
        }
        if (Objects.notEquals((Object)style, (Object[])new Object[]{-1, 0, 1, 2, 3})) {
            throw new IllegalArgumentException("Unknown font style: " + style);
        }
        this.startIndex = startIndex;
        this.length = length;
        this.foreground = foreground;
        this.background = background;
        this.style = style;
        this.customStyles = customStyles;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLength() {
        return this.length;
    }

    public int getStyle() {
        return this.style;
    }

    @Nullable
    public Color getForeground() {
        return this.foreground;
    }

    @Nullable
    public Color getBackground() {
        return this.background;
    }

    public boolean isStrikeThrough() {
        return this.customStyles.contains((Object)CustomStyle.strikeThrough);
    }

    public boolean isDoubleStrikeThrough() {
        return this.customStyles.contains((Object)CustomStyle.doubleStrikeThrough);
    }

    public boolean isWaved() {
        return this.customStyles.contains((Object)CustomStyle.waved);
    }

    public boolean isUnderlined() {
        return this.customStyles.contains((Object)CustomStyle.underlined);
    }

    public boolean isSuperscript() {
        return this.customStyles.contains((Object)CustomStyle.superscript);
    }

    public boolean isSubscript() {
        return this.customStyles.contains((Object)CustomStyle.subscript);
    }

    @NotNull
    public List<CustomStyle> getCustomStyle() {
        return this.customStyles;
    }

    @NotNull
    public StyleRange merge(@NotNull RecursiveMerge merge, @NotNull Class type, @NotNull StyleRange object, int depth) {
        StyleRange result = (StyleRange)merge.mergeFields(type, (Object)this, (Object)object, depth);
        int fontStyle = object.style != -1 ? (this.style != -1 ? this.style | object.style : object.style) : this.style;
        ReflectUtils.setFieldValueSafely((Object)result, (String)"style", (Object)fontStyle);
        return result;
    }
}

