/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentPanelLayout
extends AbstractLayoutManager {
    protected List<Component> components = new ArrayList<Component>();
    protected Map<Component, Integer> yShift = new HashMap<Component, Integer>();

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponentShift(Component component, Integer shift) {
        this.yShift.put(component, shift);
    }

    public Integer getComponentShift(Component component) {
        return this.yShift.get(component);
    }

    public int indexOf(Component component) {
        return this.components.indexOf(component);
    }

    public Component getComponent(int index) {
        return this.components.get(index);
    }

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        this.components.add(component);
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        this.components.remove(component);
    }

    public void insertLayoutComponent(int index, Component component) {
        this.components.add(index, component);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Insets insets = container.getInsets();
        int width = insets.left + insets.right;
        int height = insets.top + insets.bottom;
        for (Component component : this.components) {
            Dimension ps = component.getPreferredSize();
            width = Math.max(width, insets.left + ps.width + insets.right);
            height += ps.height;
        }
        return new Dimension(width, height);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Insets insets = container.getInsets();
        int y = insets.top;
        for (Component component : this.components) {
            Dimension ps = component.getPreferredSize();
            Integer shift = this.yShift.get(component);
            component.setBounds(insets.left, shift == null ? y : y + shift, container.getWidth() - insets.left - insets.right, ps.height);
            y += ps.height;
        }
    }
}

