/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class FormLayout
extends AbstractLayoutManager {
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String FILL = "fill";
    public static final String LINE = "line";
    protected boolean fillLeftSide;
    protected boolean fillRightSide;
    protected boolean fillLeftSideHeight;
    protected boolean fillRightSideHeight;
    protected int leftVerticalAlignment;
    protected int rightVerticalAlignment;
    protected int horizontalGap;
    protected int verticalGap;
    protected Map<Component, String> layoutConstraints = new HashMap<Component, String>();

    public FormLayout() {
        this(false, true, 0, 0);
    }

    public FormLayout(boolean fillLeftSide, boolean fillRightSide) {
        this(fillLeftSide, fillRightSide, 0, 0);
    }

    public FormLayout(int horizontalGap, int verticalGap) {
        this(false, true, horizontalGap, verticalGap);
    }

    public FormLayout(boolean fillLeftSide, boolean fillRightSide, int horizontalGap, int verticalGap) {
        this.fillLeftSide = fillLeftSide;
        this.fillRightSide = fillRightSide;
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
        this.fillLeftSideHeight = false;
        this.fillRightSideHeight = false;
        this.leftVerticalAlignment = 0;
        this.rightVerticalAlignment = 0;
    }

    public boolean isFillLeftSide() {
        return this.fillLeftSide;
    }

    public void setFillLeftSide(boolean fillLeftSide) {
        this.fillLeftSide = fillLeftSide;
    }

    public boolean isFillRightSide() {
        return this.fillRightSide;
    }

    public void setFillRightSide(boolean fillRightSide) {
        this.fillRightSide = fillRightSide;
    }

    public boolean isFillLeftSideHeight() {
        return this.fillLeftSideHeight;
    }

    public void setFillLeftSideHeight(boolean fillLeftSideHeight) {
        this.fillLeftSideHeight = fillLeftSideHeight;
    }

    public boolean isFillRightSideHeight() {
        return this.fillRightSideHeight;
    }

    public void setFillRightSideHeight(boolean fillRightSideHeight) {
        this.fillRightSideHeight = fillRightSideHeight;
    }

    public int getLeftVerticalAlignment() {
        return this.leftVerticalAlignment;
    }

    public void setLeftVerticalAlignment(int leftVerticalAlignment) {
        this.leftVerticalAlignment = leftVerticalAlignment;
    }

    public int getRightVerticalAlignment() {
        return this.rightVerticalAlignment;
    }

    public void setRightVerticalAlignment(int rightVerticalAlignment) {
        this.rightVerticalAlignment = rightVerticalAlignment;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public void setHorizontalGap(int horizontalGap) {
        this.horizontalGap = horizontalGap;
    }

    public int getVerticalGap() {
        return this.verticalGap;
    }

    public void setVerticalGap(int verticalGap) {
        this.verticalGap = verticalGap;
    }

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        Container container = component.getParent();
        int cc = container.getComponentCount();
        boolean wasFirstColumn = false;
        for (int j = 0; j < cc; ++j) {
            Component c = container.getComponent(j);
            String lc = this.layoutConstraints.get(c);
            if (lc != null) {
                boolean bl = wasFirstColumn = !wasFirstColumn && !lc.equals(LINE);
            }
            if (c != component) continue;
            String halign = constraints != null ? "" + constraints : (wasFirstColumn ? FILL : RIGHT);
            this.layoutConstraints.put(component, halign);
            break;
        }
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        this.layoutConstraints.remove(component);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        int cc = container.getComponentCount();
        if (cc > 0) {
            Map<Component, Dimension> cps = SwingUtils.getChildPreferredSizes(container);
            int lpw = 0;
            int rpw = 0;
            boolean wasFirstColumn = false;
            for (int j = 0; j < cc; ++j) {
                Component component = container.getComponent(j);
                Dimension ps = cps.get(component);
                if (!wasFirstColumn) {
                    if (this.layoutConstraints.get(component).equals(LINE)) {
                        wasFirstColumn = false;
                        continue;
                    }
                    lpw = Math.max(lpw, ps.width);
                    wasFirstColumn = true;
                    continue;
                }
                rpw = Math.max(lpw, ps.width);
                wasFirstColumn = false;
            }
            Dimension parentSize = container.getSize();
            Insets i = container.getInsets();
            if (this.fillLeftSide && this.fillRightSide) {
                if (cc > 1) {
                    rpw = lpw = (parentSize.width - i.left - i.right - this.horizontalGap) / 2;
                } else {
                    lpw = parentSize.width - i.left - i.right;
                }
            } else if (this.fillLeftSide) {
                lpw = cc > 1 ? parentSize.width - i.left - i.right - this.horizontalGap - rpw : parentSize.width - i.left - i.right;
            } else if (cc > 1) {
                rpw = parentSize.width - i.left - i.right - this.horizontalGap - lpw;
            }
            int x1 = i.left;
            int x2 = i.left + lpw + this.horizontalGap;
            int w = parentSize.width - i.left - i.right;
            int y = i.top;
            wasFirstColumn = false;
            for (int j = 0; j < cc; ++j) {
                int aw;
                int ch;
                int cy;
                int rh;
                Component component = container.getComponent(j);
                Dimension ps = cps.get(component);
                String pos = this.layoutConstraints.get(component);
                if (!wasFirstColumn) {
                    if (pos.equals(LINE)) {
                        int rh2 = ps.height;
                        component.setBounds(x1, y, w, rh2);
                        y += rh2 + this.verticalGap;
                        wasFirstColumn = false;
                        continue;
                    }
                    int next = cc > j + 1 ? cps.get((Object)container.getComponent((int)(j + 1))).height : 0;
                    rh = Math.max(ps.height, next);
                    cy = this.fillLeftSideHeight ? y : this.getSideY(true, y, rh, ps.height);
                    ch = this.fillLeftSideHeight ? rh : ps.height;
                    aw = Math.min(ps.width, lpw);
                    if (pos.equals(LEFT)) {
                        component.setBounds(x1, cy, aw, ch);
                    } else if (pos.equals(CENTER)) {
                        component.setBounds(x1 + lpw / 2 - aw / 2, cy, aw, ch);
                    } else if (pos.equals(RIGHT)) {
                        component.setBounds(x1 + lpw - aw, cy, aw, ch);
                    } else if (pos.equals(FILL)) {
                        component.setBounds(x1, cy, lpw, ch);
                    }
                    wasFirstColumn = true;
                    continue;
                }
                int prev = cps.get((Object)container.getComponent((int)(j - 1))).height;
                rh = Math.max(ps.height, prev);
                cy = this.fillRightSideHeight ? y : this.getSideY(false, y, rh, ps.height);
                ch = this.fillRightSideHeight ? rh : ps.height;
                aw = Math.min(ps.width, rpw);
                if (pos.equals(LEFT)) {
                    component.setBounds(x2, cy, aw, ch);
                } else if (pos.equals(CENTER)) {
                    component.setBounds(x2 + rpw / 2 - aw / 2, cy, aw, ch);
                } else if (pos.equals(RIGHT)) {
                    component.setBounds(x2 + rpw - aw, cy, aw, ch);
                } else if (pos.equals(FILL)) {
                    component.setBounds(x2, cy, rpw, ch);
                }
                y += rh + this.verticalGap;
                wasFirstColumn = false;
            }
        }
    }

    protected int getSideY(boolean leftSide, int rowY, int rowHeight, int componentHeight) {
        if (leftSide ? this.leftVerticalAlignment == 0 : this.rightVerticalAlignment == 0) {
            return rowY + rowHeight / 2 - componentHeight / 2;
        }
        if (leftSide ? this.leftVerticalAlignment == 1 : this.rightVerticalAlignment == 1) {
            return rowY;
        }
        if (leftSide ? this.leftVerticalAlignment == 3 : this.rightVerticalAlignment == 3) {
            return rowY + rowHeight - componentHeight;
        }
        return rowY;
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        int cc = container.getComponentCount();
        Insets i = container.getInsets();
        if (cc > 0) {
            Map<Component, Dimension> cps = SwingUtils.getChildPreferredSizes(container);
            int pw = 0;
            int lpw = 0;
            int rpw = 0;
            int ph = 0;
            boolean wasFirstColumn = false;
            for (int j = 0; j < cc; ++j) {
                Component thisComponent = container.getComponent(j);
                Dimension ps = cps.get(thisComponent);
                if (!wasFirstColumn) {
                    if (this.layoutConstraints.get(thisComponent).equals(LINE)) {
                        pw = Math.max(pw, ps.width);
                        ph += ps.height + this.verticalGap;
                        wasFirstColumn = false;
                        continue;
                    }
                    lpw = Math.max(lpw, ps.width);
                    int next = cc > j + 1 ? cps.get((Object)container.getComponent((int)(j + 1))).height : 0;
                    ph += Math.max(ps.height, next) + this.verticalGap;
                    wasFirstColumn = true;
                    continue;
                }
                rpw = Math.max(rpw, ps.width);
                wasFirstColumn = false;
            }
            ph -= this.verticalGap;
            if (this.fillLeftSide && this.fillRightSide) {
                rpw = lpw = Math.max(lpw, rpw);
            }
            return new Dimension(i.left + Math.max(lpw + this.horizontalGap + rpw, pw) + i.right, i.top + ph + i.bottom);
        }
        return new Dimension(i.left + i.right, i.top + i.bottom);
    }
}

