/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class HorizontalOverflowLayout
extends AbstractLayoutManager {
    protected int overflow;

    public HorizontalOverflowLayout(int overflow) {
        this.overflow = overflow;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public void setOverflow(int overflow) {
        this.overflow = overflow;
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, true);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Dimension required = this.preferredLayoutSize(container);
        Dimension available = new Dimension(required.width, container.getSize().height);
        boolean min = required.width < available.width;
        Insets insets = container.getInsets();
        int x = insets.left;
        int y = insets.top;
        int h = Math.max(available.height, required.height) - insets.top - insets.bottom;
        int xsWidth = available.width - required.width;
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            int w;
            Component c = container.getComponent(i);
            if (!c.isVisible()) continue;
            int n = w = min ? c.getMinimumSize().width : c.getPreferredSize().width;
            if (xsWidth > 0) {
                w += w * xsWidth / required.width;
            }
            c.setBounds(x, y, w, h);
            x += w - this.overflow;
        }
    }

    protected Dimension getLayoutSize(Container container, boolean min) {
        int count = container.getComponentCount();
        Dimension size = new Dimension(0, 0);
        for (int i = 0; i < count; ++i) {
            Component c = container.getComponent(i);
            Dimension tmp = min ? c.getMinimumSize() : c.getPreferredSize();
            size.height = Math.max(tmp.height, size.height);
            size.width += tmp.width;
            if (i == 0) continue;
            size.width -= this.overflow;
        }
        Insets border = container.getInsets();
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }
}

