/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class VerticalFlowLayout
extends AbstractLayoutManager {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    protected int align;
    @Deprecated
    protected int hgap;
    protected int vgap;
    protected boolean hfill;
    protected boolean vfill;

    public VerticalFlowLayout() {
        this(0, 0, 0, true, false);
    }

    public VerticalFlowLayout(boolean hfill, boolean vfill) {
        this(0, 0, 0, hfill, vfill);
    }

    public VerticalFlowLayout(int hgap, int vgap) {
        this(0, hgap, vgap, true, false);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap) {
        this(align, hgap, vgap, true, false);
    }

    public VerticalFlowLayout(int align) {
        this(align, 0, 0, true, false);
    }

    public VerticalFlowLayout(int align, boolean hfill, boolean vfill) {
        this(align, 0, 0, hfill, vfill);
    }

    public VerticalFlowLayout(int hgap, int vgap, boolean hfill, boolean vfill) {
        this(0, hgap, vgap, hfill, vfill);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap, boolean hfill, boolean vfill) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
        this.hfill = hfill;
        this.vfill = vfill;
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public void setHorizontalGap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVerticalGap(int vgap) {
        this.vgap = vgap;
    }

    public void setVerticalFill(boolean vfill) {
        this.vfill = vfill;
    }

    public void setHorizontalFill(boolean hfill) {
        this.hfill = hfill;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        Insets insets = container.getInsets();
        Dimension size = container.getSize();
        int maxwidth = size.width - (insets.left + insets.right);
        int maxheight = size.height - (insets.top + insets.bottom);
        int numcomp = container.getComponentCount();
        int pheight = !this.vfill && this.align != 0 ? this.calculatePreferredHeight(container) : 0;
        int y = 0;
        for (int i = 0; i < numcomp; ++i) {
            int x;
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension ps = component.getPreferredSize();
            int w = this.hfill ? maxwidth : Math.min(maxwidth, ps.width);
            int h = this.vfill && i == numcomp - 1 ? maxheight - y : ps.height;
            int n = x = ltr || this.hfill ? insets.left : insets.left + maxwidth - w;
            if (this.vfill) {
                component.setBounds(x, insets.top + y, w, h);
            } else {
                switch (this.align) {
                    case 1: {
                        component.setBounds(x, insets.top + maxheight / 2 - pheight / 2 + y, w, ps.height);
                        break;
                    }
                    case 2: {
                        component.setBounds(x, size.height - insets.bottom - pheight + y, w, ps.height);
                        break;
                    }
                    default: {
                        component.setBounds(x, insets.top + y, w, ps.height);
                    }
                }
            }
            y += h + this.getVgap();
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, true);
    }

    protected Dimension getLayoutSize(Container container, boolean minimum) {
        Dimension size = new Dimension(0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension componentSize = minimum ? component.getMinimumSize() : component.getPreferredSize();
            size.width = Math.max(size.width, componentSize.width);
            if (i > 0) {
                size.height += this.getVgap();
            }
            size.height += componentSize.height;
        }
        Insets insets = container.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    protected int calculatePreferredHeight(Container container) {
        int ph = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            ph += container.getComponent((int)i).getPreferredSize().height;
            if (i >= container.getComponentCount() - 1) continue;
            ph += this.getVgap();
        }
        return ph;
    }
}

