/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.lazy;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class LazyPanelLayout
extends AbstractLayoutManager {
    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        Container container = component.getParent();
        if (container != null && container.getComponentCount() > 1) {
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                Component other = container.getComponent(i);
                if (other == component) continue;
                container.remove(i);
            }
        }
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        if (parent.getComponentCount() > 0) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            Insets insets = parent.getInsets();
            Component component = parent.getComponent(0);
            component.setBounds(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Dimension ps = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        if (parent.getComponentCount() > 0) {
            Dimension cps = parent.getComponent(0).getPreferredSize();
            ps.width += cps.width;
            ps.height += cps.height;
        }
        return ps;
    }
}

