/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.link;

import com.alee.api.annotations.NotNull;
import com.alee.extended.label.WStyledLabelUI;
import com.alee.extended.link.WebLink;
import com.alee.managers.style.BoundsType;
import com.alee.utils.SwingUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public abstract class WLinkUI<C extends WebLink>
extends WStyledLabelUI<C> {
    protected MouseAdapter linkExecutionListener;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "Link.";
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        ((WebLink)this.label).setFocusable(false);
        ((WebLink)this.label).setVisitable(true);
        ((WebLink)this.label).setVisited(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.linkExecutionListener = new MouseAdapter(){
            private boolean pressed;

            @Override
            public void mousePressed(MouseEvent e) {
                if (((WebLink)WLinkUI.this.label).isEnabled() && SwingUtils.isLeftMouseButton(e) && BoundsType.margin.bounds(WLinkUI.this.label).contains(e.getPoint())) {
                    this.pressed = true;
                    if (((WebLink)WLinkUI.this.label).isFocusable()) {
                        ((WebLink)WLinkUI.this.label).requestFocusInWindow();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtils.isLeftMouseButton(e)) {
                    if (((WebLink)WLinkUI.this.label).isEnabled() && this.pressed && BoundsType.margin.bounds(WLinkUI.this.label).contains(e.getPoint())) {
                        ((WebLink)WLinkUI.this.label).fireLinkExecuted();
                    }
                    this.pressed = false;
                }
            }
        };
        ((WebLink)this.label).addMouseListener(this.linkExecutionListener);
    }

    @Override
    protected void uninstallListeners() {
        ((WebLink)this.label).removeMouseListener(this.linkExecutionListener);
        this.linkExecutionListener = null;
        super.uninstallListeners();
    }
}

