/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.CheckBoxCellData;
import com.alee.extended.list.WebCheckBoxListElement;
import com.alee.managers.style.StyleId;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WebCheckBoxListCellRenderer
implements ListCellRenderer {
    protected final Map<String, WebCheckBoxListElement> elements = new HashMap<String, WebCheckBoxListElement>();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        CheckBoxCellData data = (CheckBoxCellData)value;
        WebCheckBoxListElement renderer = this.getElement(list, data);
        renderer.setFont(list.getFont());
        renderer.setEnabled(list.isEnabled());
        renderer.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        renderer.setText(data.getUserObject() == null ? "" : data.getUserObject().toString());
        renderer.setComponentOrientation(list.getComponentOrientation());
        return renderer;
    }

    public WebCheckBoxListElement getElement(JList list, CheckBoxCellData data) {
        String key = data.getId();
        if (this.elements.containsKey(key)) {
            WebCheckBoxListElement element = this.elements.get(key);
            element.setSelected(data.isSelected());
            return element;
        }
        StyleId elementId = StyleId.checkboxlistCellRenderer.at(list);
        WebCheckBoxListElement element = new WebCheckBoxListElement(elementId, data.isSelected());
        this.elements.put(key, element);
        return element;
    }
}

