/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.memorybar;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.extended.WebComponent;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.memorybar.MemoryBarInputListener;
import com.alee.extended.memorybar.WMemoryBarInputListener;
import com.alee.extended.memorybar.WebMemoryBar;
import com.alee.laf.WebUI;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public abstract class WMemoryBarUI<C extends WebMemoryBar>
extends ComponentUI
implements WebUI<C> {
    protected C memoryBar;
    protected MemoryUsage memoryUsage;
    protected WebStyledLabel toolTipLabel;
    protected WebTimer updater;
    protected PropertyChangeListener propertyChangeListener;
    protected MemoryBarInputListener<C> inputListener;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "MemoryBar.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.memoryBar = (WebMemoryBar)c;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.memoryBar = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.memoryBar, this.getPropertyPrefix());
        this.updateMemoryUsage();
        this.installToolTip();
    }

    protected void uninstallDefaults() {
        this.uninstallToolTip();
        LafUtils.uninstallDefaults(this.memoryBar);
    }

    protected void installListeners() {
        this.updater = WebTimer.repeat((boolean)true, (String)("WebMemoryBar#" + this.memoryBar.hashCode() + "#memoryUsageUpdater"), (long)1000L, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                final MemoryUsage memoryUsage = WMemoryBarUI.this.getRuntimeMemoryUsage();
                CoreSwingUtils.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WMemoryBarUI.this.updateMemoryUsage(memoryUsage);
                    }
                });
            }
        });
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if (Objects.equals((Object)property, (Object)"displayMaximumMemory")) {
                    WMemoryBarUI.this.updateMemoryUsage(WMemoryBarUI.this.memoryUsage);
                    ((Component)WMemoryBarUI.this.memoryBar).repaint();
                } else if (Objects.equals((Object)property, (Object)"displayToolTip")) {
                    if (((WebMemoryBar)WMemoryBarUI.this.memoryBar).isToolTipDisplayed()) {
                        WMemoryBarUI.this.installToolTip();
                    } else {
                        WMemoryBarUI.this.uninstallToolTip();
                    }
                } else if (Objects.equals((Object)property, (Object)"refreshRate")) {
                    WMemoryBarUI.this.updater.setDelay(((WebMemoryBar)WMemoryBarUI.this.memoryBar).getRefreshRate());
                }
            }
        };
        ((Container)this.memoryBar).addPropertyChangeListener(this.propertyChangeListener);
        this.inputListener = this.createButtonInputListener();
        this.inputListener.install(this.memoryBar);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.memoryBar);
        this.inputListener = null;
        ((Component)this.memoryBar).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.updater.stop();
        this.updater = null;
    }

    @NotNull
    protected MemoryBarInputListener<C> createButtonInputListener() {
        return new WMemoryBarInputListener();
    }

    protected void installToolTip() {
        if (this.toolTipLabel == null && ((WebMemoryBar)this.memoryBar).isToolTipDisplayed()) {
            this.toolTipLabel = new WebStyledLabel(StyleId.memorybarToolTip.at((JComponent)this.memoryBar), (Icon)Icons.memory);
            this.toolTipLabel.setLanguage(((WebMemoryBar)this.memoryBar).getToolTipKey(), ((WebMemoryBar)this.memoryBar).getToolTipData(this.memoryUsage));
            ((WebComponent)this.memoryBar).setToolTip(this.toolTipLabel);
        }
    }

    protected void uninstallToolTip() {
        if (this.toolTipLabel != null) {
            ((WebComponent)this.memoryBar).removeToolTips();
            this.toolTipLabel = null;
        }
    }

    @NotNull
    protected MemoryUsage getRuntimeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
    }

    @NotNull
    public MemoryUsage getMemoryUsage() {
        return this.memoryUsage;
    }

    public void updateMemoryUsage() {
        this.updateMemoryUsage(this.getRuntimeMemoryUsage());
    }

    protected void updateMemoryUsage(@NotNull MemoryUsage memoryUsage) {
        this.memoryUsage = memoryUsage;
        if (this.toolTipLabel != null) {
            this.toolTipLabel.updateLanguage(((WebMemoryBar)this.memoryBar).getToolTipData(memoryUsage));
        }
        ((Component)this.memoryBar).repaint();
    }
}

