/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.menu;

import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class WebDynamicMenuItem
extends JComponent {
    protected ImageIcon icon;
    protected String text;
    protected ActionListener action;
    protected Insets margin = new Insets(4, 4, 4, 8);
    protected Insets textMargin = new Insets(3, 6, 3, 6);
    protected boolean paintBorder = true;
    protected Color borderColor = new Color(89, 122, 222);
    protected Color borderBackground = new Color(255, 255, 255, 220);
    protected Color disabledBorderColor = new Color(149, 151, 170);
    protected Color disabledBorderBackground = new Color(255, 255, 255, 180);
    protected Color rolloverBackground = new Color(0, 0, 0, 150);
    protected int iconTextGap = 5;
    private boolean rollover;

    public WebDynamicMenuItem() {
        this.initialize();
    }

    public WebDynamicMenuItem(ImageIcon icon) {
        this.icon = icon;
        this.initialize();
    }

    public WebDynamicMenuItem(ImageIcon icon, ActionListener action) {
        this.icon = icon;
        this.action = action;
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 200));
        this.setForeground(Color.WHITE);
        this.setFont(SwingUtils.getDefaultLabelFont());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WebDynamicMenuItem.this.rollover = true;
                WebDynamicMenuItem.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebDynamicMenuItem.this.rollover = false;
                WebDynamicMenuItem.this.repaint();
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ActionListener getAction() {
        return this.action;
    }

    public void setAction(ActionListener action) {
        this.action = action;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
    }

    public void setMargin(int margin) {
        this.margin = new Insets(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.margin = new Insets(top, left, bottom, right);
    }

    public boolean isPaintBorder() {
        return this.paintBorder;
    }

    public void setPaintBorder(boolean paintBorder) {
        this.paintBorder = paintBorder;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderBackground() {
        return this.borderBackground;
    }

    public void setBorderBackground(Color color) {
        this.borderBackground = color;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        this.disabledBorderColor = color;
    }

    public Color getDisabledBorderBackground() {
        return this.disabledBorderBackground;
    }

    public void setDisabledBorderBackground(Color color) {
        this.disabledBorderBackground = color;
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public void setRolloverBackground(Color color) {
        this.rolloverBackground = color;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        int h = this.getHeight();
        int iw = h - this.margin.top - this.margin.bottom;
        if (this.icon != null) {
            if (this.isPaintBorder()) {
                Area outer = new Area(new Ellipse2D.Double(0.0, 0.0, h, h));
                Ellipse2D.Double inner = new Ellipse2D.Double(2.0, 2.0, h - 4, h - 4);
                outer.exclusiveOr(new Area(inner));
                g2d.setPaint(this.isEnabled() ? this.getBorderColor() : this.getDisabledBorderColor());
                g2d.fill(outer);
                g2d.setPaint(this.isEnabled() ? this.getBorderBackground() : this.getDisabledBorderBackground());
                g2d.fill(inner);
            }
            g2d.drawImage(this.icon.getImage(), this.margin.left + iw / 2 - this.icon.getIconWidth() / 2, this.margin.top + iw / 2 - this.icon.getIconHeight() / 2, null);
        }
        if (this.text != null) {
            g2d.setFont(this.getFont());
            FontMetrics fm = g2d.getFontMetrics();
            int tw = fm.stringWidth(this.text);
            int th = fm.getHeight();
            int ts = LafUtils.getTextCenterShiftY(fm);
            int tx = this.margin.left + iw + this.iconTextGap;
            int ty = this.margin.top + iw / 2 - th / 2 - this.textMargin.top;
            Rectangle tr = new Rectangle(tx, ty, this.textMargin.left + tw + this.textMargin.right, this.textMargin.top + th + this.textMargin.bottom);
            g2d.setPaint(this.rollover ? this.getRolloverBackground() : this.getBackground());
            g2d.fillRoundRect(tr.x, tr.y, tr.width, tr.height, 6, 6);
            int ath = tr.height - this.textMargin.top - this.textMargin.bottom;
            g2d.setPaint(this.getForeground());
            g2d.drawString(this.text, tr.x + this.textMargin.left, tr.y + this.textMargin.top + ath / 2 + ts);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        if (this.icon != null) {
            size.width += this.icon.getIconWidth();
            size.height = this.icon.getIconHeight();
        }
        if (this.icon != null && this.text != null) {
            size.width += this.iconTextGap;
        }
        if (this.text != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int tw = fm.stringWidth(this.text);
            int th = fm.getHeight();
            size.width += this.textMargin.left + tw + this.textMargin.right;
            size.height = Math.max(size.height, th);
        }
        size.width += this.margin.left + this.margin.right;
        size.height += this.margin.top + this.margin.bottom;
        return size;
    }
}

