/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.split.IMultiSplitPaneDividerPainter;
import com.alee.extended.split.MultiSplitExpansionListener;
import com.alee.extended.split.MultiSplitPaneModel;
import com.alee.extended.split.MultiSplitResizeAdapter;
import com.alee.extended.split.MultiSplitResizeListener;
import com.alee.extended.split.WMultiSplitPaneDividerUI;
import com.alee.extended.split.WebMultiSplitPane;
import com.alee.extended.split.WebMultiSplitPaneDivider;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public class MultiSplitPaneDividerPainter<C extends WebMultiSplitPaneDivider, U extends WMultiSplitPaneDividerUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements IMultiSplitPaneDividerPainter<C, U> {
    protected transient PropertyChangeListener splitPanePropertyChangeListener;
    protected transient MultiSplitExpansionListener multiSplitExpansionListener;
    protected transient MultiSplitResizeListener multiSplitResizeListener;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        if (((WebMultiSplitPaneDivider)this.component).getMultiSplitPane() != null) {
            this.installMultiSplitPaneListeners(((WebMultiSplitPaneDivider)this.component).getMultiSplitPane());
        }
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        if (((WebMultiSplitPaneDivider)this.component).getMultiSplitPane() != null) {
            this.uninstallMultiSplitPaneListeners(((WebMultiSplitPaneDivider)this.component).getMultiSplitPane());
        }
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"splitPane")) {
            if (oldValue instanceof WebMultiSplitPane) {
                this.uninstallMultiSplitPaneListeners((WebMultiSplitPane)oldValue);
            }
            if (newValue instanceof WebMultiSplitPane) {
                this.installMultiSplitPaneListeners((WebMultiSplitPane)newValue);
            }
        }
    }

    protected void installMultiSplitPaneListeners(@NotNull WebMultiSplitPane multiSplitPane) {
        this.splitPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (Objects.equals((Object)event.getPropertyName(), (Object[])new Object[]{"orientation", "continuousLayout", "oneTouchExpandable"})) {
                    MultiSplitPaneDividerPainter.this.updateDecorationState();
                }
            }
        };
        multiSplitPane.addPropertyChangeListener(this.splitPanePropertyChangeListener);
        this.multiSplitExpansionListener = new MultiSplitExpansionListener(){

            @Override
            public void viewExpanded(@NotNull WebMultiSplitPane multiSplitPane, @NotNull Component view) {
                MultiSplitPaneDividerPainter.this.updateDecorationState();
            }

            @Override
            public void viewCollapsed(@NotNull WebMultiSplitPane multiSplitPane, @NotNull Component view) {
                MultiSplitPaneDividerPainter.this.updateDecorationState();
            }
        };
        multiSplitPane.addExpansionListener(this.multiSplitExpansionListener);
        this.multiSplitResizeListener = new MultiSplitResizeAdapter(){

            @Override
            public void viewResizeStarted(@NotNull WebMultiSplitPane multiSplitPane, @NotNull WebMultiSplitPaneDivider divider) {
                MultiSplitPaneDividerPainter.this.updateDecorationState();
            }

            @Override
            public void viewResizeEnded(@NotNull WebMultiSplitPane multiSplitPane, @NotNull WebMultiSplitPaneDivider divider) {
                MultiSplitPaneDividerPainter.this.updateDecorationState();
            }
        };
        multiSplitPane.addResizeListener(this.multiSplitResizeListener);
    }

    protected void uninstallMultiSplitPaneListeners(@NotNull WebMultiSplitPane multiSplitPane) {
        multiSplitPane.removeResizeListener(this.multiSplitResizeListener);
        this.multiSplitResizeListener = null;
        multiSplitPane.removeExpansionListener(this.multiSplitExpansionListener);
        this.multiSplitExpansionListener = null;
        multiSplitPane.removePropertyChangeListener(this.splitPanePropertyChangeListener);
        this.splitPanePropertyChangeListener = null;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        MultiSplitPaneModel model;
        List<String> states = super.getDecorationStates();
        WebMultiSplitPane multiSplitPane = ((WebMultiSplitPaneDivider)this.component).getMultiSplitPane();
        states.add(((WebMultiSplitPaneDivider)this.component).getOrientation().isVertical() ? "vertical" : "horizontal");
        states.add(multiSplitPane.isContinuousLayout() ? "continuous" : "non-continuous");
        if (multiSplitPane.isOneTouchExpandable()) {
            states.add("one-touch");
        }
        if ((model = multiSplitPane.getModel()) != null) {
            if (model.getDraggedDivider() == this.component) {
                states.add("dragged");
            }
            if (multiSplitPane.isAnyViewExpanded()) {
                int expanded = multiSplitPane.getExpandedViewIndex();
                int index = model.getDividerIndex((WebMultiSplitPaneDivider)this.component);
                if (index < expanded) {
                    states.add("start");
                } else {
                    states.add("end");
                }
            }
        }
        return states;
    }
}

