/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.Clone;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.split.MultiSplitConstraints;
import com.alee.extended.split.MultiSplitLayoutHelper;
import com.alee.extended.split.MultiSplitPaneModel;
import com.alee.extended.split.MultiSplitState;
import com.alee.extended.split.MultiSplitView;
import com.alee.extended.split.MultiSplitViewState;
import com.alee.extended.split.WebMultiSplitPane;
import com.alee.extended.split.WebMultiSplitPaneDivider;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.swing.SizeType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class WebMultiSplitPaneModel
extends AbstractLayoutManager
implements MultiSplitPaneModel,
PropertyChangeListener {
    protected final List<MultiSplitView> views = new ArrayList<MultiSplitView>();
    protected final List<WebMultiSplitPaneDivider> dividers = new ArrayList<WebMultiSplitPaneDivider>(2);
    protected EventListenerList listeners = new EventListenerList();
    protected WebMultiSplitPane multiSplitPane;
    protected transient boolean initialized;
    protected transient Operation lastOperation;
    protected transient int draggedDividerIndex;
    protected transient Point dragStart;
    protected transient List<MultiSplitView> viewsCopy;

    public WebMultiSplitPaneModel() {
        this.listeners.add(ComponentListener.class, new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WebMultiSplitPaneModel.this.onOperation(Operation.splitPaneResized);
            }
        });
        this.draggedDividerIndex = -1;
        this.dragStart = null;
    }

    @Override
    public void install(@NotNull WebMultiSplitPane multiSplitPane, @Nullable List<MultiSplitView> views, @Nullable List<WebMultiSplitPaneDivider> dividers) {
        if (this.multiSplitPane == null) {
            this.initialized = false;
            this.multiSplitPane = multiSplitPane;
            this.multiSplitPane.addPropertyChangeListener(this);
            for (ComponentListener listener : (ComponentListener[])this.listeners.getListeners(ComponentListener.class)) {
                this.multiSplitPane.addComponentListener(listener);
            }
            if (CollectionUtils.notEmpty(views)) {
                this.views.addAll(views);
            }
            if (CollectionUtils.notEmpty(dividers)) {
                this.dividers.addAll(dividers);
            }
        } else {
            if (this.multiSplitPane == multiSplitPane) {
                throw new IllegalStateException("This MultiSplitPaneModel is already installed in specified WebMultiSplitPane");
            }
            throw new IllegalStateException("MultiSplitPaneModel can only be installed into single WebMultiSplitPane at a time");
        }
        this.onOperation(Operation.splitPaneModelInstalled);
    }

    @Override
    public void uninstall(@NotNull WebMultiSplitPane multiSplitPane) {
        if (this.multiSplitPane != null && this.multiSplitPane == multiSplitPane) {
            this.onOperation(Operation.splitPaneModelUninstalled);
            this.views.clear();
            this.dividers.clear();
            for (ComponentListener listener : (ComponentListener[])this.listeners.getListeners(ComponentListener.class)) {
                this.multiSplitPane.removeComponentListener(listener);
            }
        } else {
            if (this.multiSplitPane == null) {
                throw new IllegalStateException("This MultiSplitPaneModel is not yet installed in any WebMultiSplitPane");
            }
            throw new IllegalStateException("This MultiSplitPaneModel is installed in different WebMultiSplitPane");
        }
        this.multiSplitPane.removePropertyChangeListener(this);
        this.multiSplitPane = null;
        this.initialized = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("orientation")) {
            this.onOperation(Operation.splitOrientationChanged);
        }
    }

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        if (!(component instanceof WebMultiSplitPaneDivider)) {
            MultiSplitConstraints multiSplitConstraints;
            if (constraints == null) {
                multiSplitConstraints = new MultiSplitConstraints();
            } else if (constraints instanceof Number) {
                multiSplitConstraints = new MultiSplitConstraints((Number)constraints);
            } else if (constraints instanceof String) {
                multiSplitConstraints = new MultiSplitConstraints((String)constraints);
            } else if (constraints instanceof MultiSplitConstraints) {
                multiSplitConstraints = (MultiSplitConstraints)constraints;
            } else {
                String msg = "Unknown WebMultiSplitPane layout constraints type: %s";
                throw new IllegalArgumentException(String.format("Unknown WebMultiSplitPane layout constraints type: %s", constraints));
            }
            int zOrder = this.multiSplitPane.getComponentZOrder(component);
            int viewIndex = zOrder <= this.views.size() ? zOrder : this.views.size();
            MultiSplitView view = new MultiSplitView(component, multiSplitConstraints);
            this.views.add(viewIndex, view);
            if (this.initialized) {
                if (multiSplitConstraints.isPixels()) {
                    view.state().setSize(multiSplitConstraints.pixels());
                } else if (multiSplitConstraints.isPercents() || multiSplitConstraints.isFill() || multiSplitConstraints.isPreferred()) {
                    Dimension ps = component.getPreferredSize();
                    int preferred = this.multiSplitPane.getOrientation().isHorizontal() ? ps.width : ps.height;
                    view.state().setSize(preferred);
                } else if (multiSplitConstraints.isMinimum()) {
                    Dimension ms = component.getMinimumSize();
                    int minimum = this.multiSplitPane.getOrientation().isHorizontal() ? ms.width : ms.height;
                    view.state().setSize(minimum);
                } else {
                    throw new IllegalArgumentException("Unknown view size value: " + multiSplitConstraints.size());
                }
            }
            if (this.views.size() - 1 > this.dividers.size()) {
                if (this.dividers.size() > 0) {
                    int dividerIndex = this.views.size();
                    for (WebMultiSplitPaneDivider divider : this.dividers) {
                        this.multiSplitPane.setComponentZOrderImpl(divider, dividerIndex);
                        ++dividerIndex;
                    }
                }
                int dividerIndex = viewIndex == 0 ? 0 : viewIndex - 1;
                WebMultiSplitPaneDivider divider = this.multiSplitPane.createDivider();
                this.multiSplitPane.addImpl(divider, null, this.views.size() + dividerIndex);
                this.dividers.add(dividerIndex, divider);
            }
            this.onOperation(Operation.splitViewsChanged);
        }
    }

    @Override
    public void moveComponent(@NotNull Component component, int index) {
        if (!(component instanceof WebMultiSplitPaneDivider)) {
            int oldIndex = this.getViewIndex(component);
            if (oldIndex == -1) {
                throw new IllegalArgumentException("Cannot find view for component: " + component);
            }
            if (oldIndex < 0 || this.views.size() <= oldIndex) {
                throw new IndexOutOfBoundsException("Incorrect new index: " + oldIndex);
            }
            if (oldIndex != index) {
                MultiSplitView view = this.views.remove(oldIndex);
                this.views.add(index, view);
                this.onOperation(Operation.splitViewsChanged);
                this.multiSplitPane.fireViewSizeAdjusted();
            }
        }
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        if (!(component instanceof WebMultiSplitPaneDivider)) {
            int index = this.getViewIndex(component);
            if (index == -1) {
                throw new IllegalArgumentException("Cannot find view for component: " + component);
            }
            if (this.views.size() > 1) {
                WebMultiSplitPaneDivider divider = this.dividers.get(index > 0 ? index - 1 : index);
                int zIndex = this.multiSplitPane.getComponentZOrder(divider);
                this.multiSplitPane.removeImpl(zIndex);
                this.dividers.remove(divider);
            }
            this.views.remove(index);
            this.onOperation(Operation.splitViewsChanged);
        }
    }

    @Override
    public int getViewCount() {
        return this.views.size();
    }

    @Override
    @Nullable
    public List<MultiSplitView> getViews() {
        return (List)Clone.deep().clone(this.views);
    }

    @Override
    public int getViewIndex(@NotNull Component component) {
        int index = -1;
        for (int i = 0; i < this.views.size(); ++i) {
            MultiSplitView view = this.views.get(i);
            if (view.component() != component) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    @NotNull
    public Component getViewComponent(int index) {
        return this.views.get(index).component();
    }

    @Override
    @NotNull
    public List<Component> getViewComponents() {
        ArrayList<Component> viewComponents = new ArrayList<Component>(this.views.size());
        for (MultiSplitView view : this.views) {
            viewComponents.add(view.component());
        }
        return viewComponents;
    }

    @Override
    @NotNull
    public List<WebMultiSplitPaneDivider> getDividers() {
        return new ArrayList<WebMultiSplitPaneDivider>(this.dividers);
    }

    @Override
    public int getDividerIndex(@NotNull WebMultiSplitPaneDivider divider) {
        return this.dividers.indexOf(divider);
    }

    @Override
    @Nullable
    public MultiSplitState getMultiSplitState() {
        MultiSplitState state;
        if (this.initialized) {
            state = new MultiSplitState();
            ArrayList<MultiSplitViewState> states = new ArrayList<MultiSplitViewState>(this.views.size());
            for (MultiSplitView view : this.views) {
                states.add(view.state());
            }
            state.setStates(states);
        } else {
            state = null;
        }
        return state;
    }

    @Override
    public void setMultiSplitState(@NotNull MultiSplitState state) {
        List<MultiSplitViewState> states = state.states();
        if (states.size() == this.views.size()) {
            int previouslyExpandedViewIndex = this.getExpandedViewIndex();
            for (int i = 0; i < this.views.size(); ++i) {
                this.views.get(i).setState(states.get(i));
            }
            int expandedViewIndex = this.getExpandedViewIndex();
            if (expandedViewIndex != previouslyExpandedViewIndex) {
                if (previouslyExpandedViewIndex != -1) {
                    this.multiSplitPane.fireViewCollapsed(this.views.get(previouslyExpandedViewIndex).component());
                }
                if (expandedViewIndex != -1) {
                    this.multiSplitPane.fireViewExpanded(this.views.get(expandedViewIndex).component());
                }
            }
            this.initialized = true;
            this.onOperation(Operation.splitViewsStateApplied);
        }
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        if (this.multiSplitPane.getWidth() > 0 && this.multiSplitPane.getHeight() > 0 && this.views.size() > 0) {
            this.initializeViewsStates();
            this.adjustViewsStates();
            this.layoutMultiSplitPane();
        }
    }

    protected void initializeViewsStates() {
        if (!this.initialized) {
            this.setupViewStatesFromConstraints();
            this.initialized = true;
            this.onOperation(Operation.splitViewsSizesInitialized);
        }
    }

    @Override
    public void resetViewStates() {
        this.setupViewStatesFromConstraints();
        this.multiSplitPane.revalidate();
        this.multiSplitPane.repaint();
    }

    protected void setupViewStatesFromConstraints() {
        MultiSplitLayoutHelper.Static helper = new MultiSplitLayoutHelper.Static(this.multiSplitPane, this.views, SizeType.current);
        for (MultiSplitView view : this.views) {
            int size;
            Component component = view.component();
            MultiSplitConstraints constraints = view.constraints();
            MultiSplitViewState viewState = view.state();
            if (constraints.isPixels()) {
                viewState.setSize(constraints.pixels());
                continue;
            }
            if (constraints.isPercents()) {
                double normalizedPercents = constraints.percents() / helper.totalPercentViews;
                size = (int)Math.round((double)helper.spaceForPercentViews * normalizedPercents);
                viewState.setSize(size);
                continue;
            }
            if (constraints.isFill()) {
                double normalizedPercents = helper.fillViewSize / helper.totalPercentViews;
                size = (int)Math.round((double)helper.spaceForPercentViews * normalizedPercents);
                viewState.setSize(size);
                continue;
            }
            if (constraints.isPreferred()) {
                Dimension ps = helper.size(component, SizeType.preferred);
                int preferred = helper.horizontal ? ps.width : ps.height;
                viewState.setSize(preferred);
                continue;
            }
            if (constraints.isMinimum()) {
                Dimension ms = helper.size(component, SizeType.minimum);
                int minimum = helper.horizontal ? ms.width : ms.height;
                viewState.setSize(minimum);
                continue;
            }
            throw new IllegalArgumentException("Unknown view size value: " + constraints.size());
        }
    }

    protected void adjustViewsStates() {
        boolean adjusted = false;
        List<MultiSplitView> baseViews = this.lastOperation == Operation.splitPaneResized ? this.viewsCopy : this.views;
        MultiSplitLayoutHelper.Runtime helper = new MultiSplitLayoutHelper.Runtime(this.multiSplitPane, baseViews);
        while (helper.space != helper.totalSizes) {
            int remainingSpaceDelta = helper.space - helper.totalSizes;
            if (Math.abs(remainingSpaceDelta) > 1) {
                if (remainingSpaceDelta > 0 ? helper.totalWeights > 0.0 : helper.nonZeroViewsWeights > 0.0) {
                    double remainingDeltaWeight = remainingSpaceDelta > 0 ? helper.totalWeights : helper.nonZeroViewsWeights;
                    for (int i = 0; i < baseViews.size(); ++i) {
                        MultiSplitView view = baseViews.get(i);
                        MultiSplitViewState viewState = view.state();
                        int size = viewState.size();
                        double viewWeight = view.constraints().weight();
                        if (viewWeight > 0.0 && (remainingSpaceDelta > 0 || size > 0)) {
                            int rawViewDelta = (int)((double)remainingSpaceDelta * viewWeight / remainingDeltaWeight);
                            int actualDelta = rawViewDelta >= 0 ? rawViewDelta : (size >= Math.abs(rawViewDelta) ? rawViewDelta : -size);
                            this.views.get(i).state().setSize(size + actualDelta);
                            remainingSpaceDelta -= actualDelta;
                            remainingDeltaWeight -= viewWeight;
                            continue;
                        }
                        this.views.get(i).state().setSize(size);
                    }
                } else {
                    double averageWeight = 1.0;
                    double remainingDeltaWeight = 1.0 * (double)(remainingSpaceDelta > 0 ? baseViews.size() : helper.nonZeroViews);
                    for (int i = 0; i < baseViews.size(); ++i) {
                        MultiSplitView view = baseViews.get(i);
                        MultiSplitViewState viewState = view.state();
                        int size = viewState.size();
                        double viewWeight = view.constraints().weight();
                        if (viewWeight == 0.0 && (remainingSpaceDelta > 0 || size > 0)) {
                            int rawViewDelta = (int)((double)remainingSpaceDelta * 1.0 / remainingDeltaWeight);
                            int actualDelta = rawViewDelta >= 0 ? rawViewDelta : (size >= Math.abs(rawViewDelta) ? rawViewDelta : -size);
                            this.views.get(i).state().setSize(size + actualDelta);
                            remainingSpaceDelta -= actualDelta;
                            remainingDeltaWeight -= 1.0;
                            continue;
                        }
                        this.views.get(i).state().setSize(size);
                    }
                }
            } else {
                for (int i = 0; i < baseViews.size(); ++i) {
                    MultiSplitViewState viewState = baseViews.get(i).state();
                    int size = viewState.size();
                    if (size <= 0 && helper.nonZeroViews != 0) continue;
                    this.views.get(i).state().setSize(size + remainingSpaceDelta);
                    break;
                }
            }
            baseViews = this.views;
            helper = new MultiSplitLayoutHelper.Runtime(this.multiSplitPane, baseViews);
            adjusted = true;
        }
        if (adjusted) {
            this.multiSplitPane.fireViewSizeAdjusted();
        }
    }

    protected void layoutMultiSplitPane() {
        Insets insets = this.multiSplitPane.getInsets();
        boolean horizontal = this.multiSplitPane.getOrientation().isHorizontal();
        int expandedIndex = this.getExpandedViewIndex();
        if (expandedIndex == -1) {
            int dividerSize = this.multiSplitPane.getDividerSize();
            int dividerWidth = horizontal ? dividerSize : this.multiSplitPane.getWidth() - insets.left - insets.right;
            int dividerHeight = horizontal ? this.multiSplitPane.getHeight() - insets.top - insets.bottom : dividerSize;
            int x = insets.left;
            int y = insets.top;
            int width = horizontal ? 0 : this.multiSplitPane.getWidth() - insets.left - insets.right;
            int height = horizontal ? this.multiSplitPane.getHeight() - insets.top - insets.bottom : 0;
            for (MultiSplitView view : this.views) {
                int index = this.views.indexOf(view);
                boolean lastComponent = index == this.views.size() - 1;
                Component component = view.component();
                MultiSplitViewState viewState = view.state();
                int size = viewState.size();
                if (horizontal) {
                    component.setBounds(x, y, size, height);
                } else {
                    component.setBounds(x, y, width, size);
                }
                if (lastComponent) continue;
                WebMultiSplitPaneDivider divider = this.dividers.get(index);
                if (horizontal) {
                    divider.setBounds(x + size, y, dividerWidth, dividerHeight);
                } else {
                    divider.setBounds(x, y + size, dividerWidth, dividerHeight);
                }
                if (horizontal) {
                    x += size + dividerSize;
                    continue;
                }
                y += size + dividerSize;
            }
        } else {
            int dividerAfterSize;
            int height;
            int width;
            int dividerBeforeSize;
            Dimension ps;
            WebMultiSplitPaneDivider dividerAfter;
            WebMultiSplitPaneDivider dividerBefore = expandedIndex > 0 ? this.dividers.get(expandedIndex - 1) : null;
            MultiSplitView expandedView = this.views.get(expandedIndex);
            WebMultiSplitPaneDivider webMultiSplitPaneDivider = dividerAfter = expandedIndex < this.views.size() - 1 ? this.dividers.get(expandedIndex) : null;
            if (dividerBefore != null) {
                ps = dividerBefore.getPreferredSize();
                dividerBeforeSize = horizontal ? ps.width : ps.height;
                width = horizontal ? dividerBeforeSize : this.multiSplitPane.getWidth() - insets.left - insets.right;
                height = horizontal ? this.multiSplitPane.getHeight() - insets.top - insets.bottom : dividerBeforeSize;
                dividerBefore.setBounds(insets.left, insets.top, width, height);
            } else {
                dividerBeforeSize = 0;
            }
            if (dividerAfter != null) {
                ps = dividerAfter.getPreferredSize();
                dividerAfterSize = horizontal ? ps.width : ps.height;
                width = horizontal ? dividerAfterSize : this.multiSplitPane.getWidth() - insets.left - insets.right;
                height = horizontal ? this.multiSplitPane.getHeight() - insets.top - insets.bottom : dividerAfterSize;
                int x = horizontal ? this.multiSplitPane.getWidth() - insets.right - width : insets.left;
                int y = horizontal ? insets.top : this.multiSplitPane.getHeight() - insets.bottom - height;
                dividerAfter.setBounds(x, y, width, height);
            } else {
                dividerAfterSize = 0;
            }
            int horBefore = horizontal && dividerBefore != null ? dividerBeforeSize : 0;
            int horAfter = horizontal && dividerAfter != null ? dividerAfterSize : 0;
            int verBefore = !horizontal && dividerBefore != null ? dividerBeforeSize : 0;
            int verAfter = !horizontal && dividerAfter != null ? dividerAfterSize : 0;
            int viewX = insets.left + horBefore;
            int viewY = insets.top + verBefore;
            int viewWidth = this.multiSplitPane.getWidth() - insets.left - insets.right - horBefore - horAfter;
            int viewHeight = this.multiSplitPane.getHeight() - insets.top - insets.bottom - verBefore - verAfter;
            expandedView.component().setBounds(viewX, viewY, viewWidth, viewHeight);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return this.layoutSize(SizeType.preferred);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return this.layoutSize(SizeType.minimum);
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@NotNull Container container) {
        return this.layoutSize(SizeType.maximum);
    }

    protected Dimension layoutSize(@NotNull SizeType sizeType) {
        Dimension contentSize;
        if (this.views.size() > 0) {
            MultiSplitLayoutHelper.Static helper = new MultiSplitLayoutHelper.Static(this.multiSplitPane, this.views, sizeType);
            int width = 0;
            int height = 0;
            int percentageSize = 0;
            for (MultiSplitView view : this.views) {
                double normalized;
                int length;
                int index = this.views.indexOf(view);
                int extra = index != this.views.size() - 1 ? this.multiSplitPane.getDividerSize() : 0;
                Component component = view.component();
                Dimension cs = helper.size(component, sizeType);
                MultiSplitConstraints constraints = view.constraints();
                if (constraints.isPixels()) {
                    length = constraints.pixels();
                } else if (constraints.isPercents()) {
                    int componentLength = helper.horizontal ? cs.width : cs.height;
                    normalized = constraints.percents() / helper.totalPercentViews;
                    percentageSize = Math.max(percentageSize, (int)((double)componentLength / normalized));
                    length = 0;
                } else if (constraints.isFill()) {
                    int componentLength = helper.horizontal ? cs.width : cs.height;
                    normalized = helper.fillViewSize / helper.totalPercentViews;
                    percentageSize = Math.max(percentageSize, (int)((double)componentLength / normalized));
                    length = 0;
                } else if (constraints.isPreferred()) {
                    Dimension ps = helper.size(component, SizeType.preferred);
                    length = helper.horizontal ? ps.width : ps.height;
                } else if (constraints.isMinimum()) {
                    Dimension ms = helper.size(component, SizeType.minimum);
                    length = helper.horizontal ? ms.width : ms.height;
                } else {
                    throw new IllegalArgumentException("Unknown view size value: " + constraints.size());
                }
                if (helper.horizontal) {
                    width += length + extra;
                    height = Math.max(height, cs.height);
                    continue;
                }
                width = Math.max(width, cs.width);
                height += length + extra;
            }
            if (helper.horizontal) {
                width += percentageSize;
            } else {
                height += percentageSize;
            }
            contentSize = new Dimension(width, height);
        } else {
            contentSize = new Dimension(0, 0);
        }
        Insets insets = this.multiSplitPane.getInsets();
        return new Dimension(insets.left + contentSize.width + insets.right, insets.top + contentSize.height + insets.bottom);
    }

    @Override
    public boolean isAnyViewExpanded() {
        return this.getExpandedViewIndex() != -1;
    }

    @Override
    public int getExpandedViewIndex() {
        int index = -1;
        for (int i = 0; i < this.views.size(); ++i) {
            if (!this.views.get(i).state().isExpanded()) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void expandView(int index) {
        if (0 <= index && index < this.views.size()) {
            int expandedIndex = this.getExpandedViewIndex();
            if (expandedIndex != index) {
                if (expandedIndex != -1) {
                    this.views.get(expandedIndex).state().setExpanded(false);
                }
                MultiSplitView newlyExpandedView = this.views.get(index);
                newlyExpandedView.state().setExpanded(true);
                for (int i = 0; i < this.views.size(); ++i) {
                    this.views.get(i).component().setVisible(i == index);
                    if (i >= this.dividers.size()) continue;
                    this.dividers.get(i).setVisible(i == index - 1 || i == index);
                }
                this.multiSplitPane.revalidate();
                this.multiSplitPane.repaint();
                this.multiSplitPane.fireViewExpanded(newlyExpandedView.component());
            }
        } else {
            throw new IndexOutOfBoundsException("WebMultiSplitPane doesn't have a view under index: " + index);
        }
    }

    @Override
    public void collapseExpandedView() {
        int expandedIndex = this.getExpandedViewIndex();
        if (expandedIndex != -1) {
            MultiSplitView previouslyExpandedView = this.views.get(expandedIndex);
            previouslyExpandedView.state().setExpanded(false);
            for (int i = 0; i < this.views.size(); ++i) {
                this.views.get(i).component().setVisible(true);
                if (i >= this.dividers.size()) continue;
                this.dividers.get(i).setVisible(true);
            }
            this.multiSplitPane.revalidate();
            this.multiSplitPane.repaint();
            this.multiSplitPane.fireViewCollapsed(previouslyExpandedView.component());
        }
    }

    @Override
    public void toggleViewExpansion(int index) {
        int expandedIndex = this.getExpandedViewIndex();
        if (expandedIndex == -1) {
            this.expandView(index);
        } else {
            this.collapseExpandedView();
        }
    }

    @Override
    public void toggleViewToLeft(@NotNull WebMultiSplitPaneDivider divider) {
        this.toggleViewExpansion(this.dividers.indexOf(divider));
    }

    @Override
    public void toggleViewToRight(@NotNull WebMultiSplitPaneDivider divider) {
        this.toggleViewExpansion(this.dividers.indexOf(divider) + 1);
    }

    @Override
    public boolean isDragAvailable(@NotNull WebMultiSplitPaneDivider divider) {
        return this.multiSplitPane.isEnabled() && this.getExpandedViewIndex() == -1 && this.dividers.contains(divider);
    }

    @Override
    @Nullable
    public WebMultiSplitPaneDivider getDraggedDivider() {
        return this.draggedDividerIndex != -1 ? this.dividers.get(this.draggedDividerIndex) : null;
    }

    @Override
    public void dividerDragStarted(@NotNull WebMultiSplitPaneDivider divider, @NotNull MouseEvent e) {
        this.onOperation(Operation.splitDividerDragged);
        this.draggedDividerIndex = this.dividers.indexOf(divider);
        if (this.draggedDividerIndex == -1) {
            throw new IllegalArgumentException("WebMultiSplitPane doesn't contain specified divider: " + divider);
        }
        this.dragStart = CoreSwingUtils.getMouseLocation();
        this.multiSplitPane.fireViewResizeStarted(divider);
    }

    @Override
    public void dividerDragged(@NotNull WebMultiSplitPaneDivider divider, @NotNull MouseEvent e) {
        this.onOperation(Operation.splitDividerDragged);
        Point mouse = CoreSwingUtils.getMouseLocation();
        int delta = this.multiSplitPane.getOrientation().isHorizontal() ? mouse.x - this.dragStart.x : mouse.y - this.dragStart.y;
        boolean straightOrder = delta > 0;
        int startFrom = delta > 0 ? this.draggedDividerIndex + 1 : this.draggedDividerIndex;
        int stretchedIndex = delta > 0 ? this.draggedDividerIndex : this.draggedDividerIndex + 1;
        int remainingDelta = Math.abs(delta);
        int startIndex = straightOrder ? 0 : this.viewsCopy.size() - 1;
        int increment = straightOrder ? 1 : -1;
        int i = startIndex;
        while (straightOrder ? i < this.viewsCopy.size() : i >= 0) {
            int size = this.viewsCopy.get(i).state().size();
            if ((straightOrder ? i >= startFrom : i <= startFrom) && remainingDelta > 0) {
                if (size < remainingDelta) {
                    this.views.get(i).state().setSize(0);
                    remainingDelta -= size;
                } else {
                    this.views.get(i).state().setSize(size - remainingDelta);
                    remainingDelta = 0;
                }
            } else {
                this.views.get(i).state().setSize(size);
            }
            i += increment;
        }
        int allowedDelta = Math.abs(delta) - remainingDelta;
        if (allowedDelta > 0) {
            int stretchedSize = this.viewsCopy.get(stretchedIndex).state().size();
            this.views.get(stretchedIndex).state().setSize(stretchedSize + allowedDelta);
        }
        this.multiSplitPane.fireViewResized(divider);
        this.multiSplitPane.revalidate();
        this.multiSplitPane.repaint();
    }

    @Override
    public void dividerDragEnded(@NotNull WebMultiSplitPaneDivider divider, @NotNull MouseEvent e) {
        this.onOperation(Operation.splitDividerDragEnded);
        this.draggedDividerIndex = -1;
        this.dragStart = null;
        this.multiSplitPane.fireViewResizeEnded(divider);
    }

    protected void onOperation(@NotNull Operation operation) {
        if (this.lastOperation != Operation.splitPaneResized && operation == Operation.splitPaneResized || this.lastOperation != Operation.splitDividerDragged && operation == Operation.splitDividerDragged) {
            this.viewsCopy = this.getViews();
        } else if (operation == Operation.splitPaneModelInstalled || operation == Operation.splitPaneModelUninstalled || operation == Operation.splitViewsSizesInitialized || operation == Operation.splitViewsStateApplied || operation == Operation.splitViewsChanged || operation == Operation.splitDividerDragEnded || operation == Operation.splitOrientationChanged) {
            this.viewsCopy = null;
        }
        this.lastOperation = operation;
    }

    protected static enum Operation {
        splitPaneModelInstalled,
        splitPaneModelUninstalled,
        splitViewsSizesInitialized,
        splitViewsStateApplied,
        splitOrientationChanged,
        splitViewsChanged,
        splitPaneResized,
        splitDividerDragged,
        splitDividerDragEnded;

    }
}

