/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.style;

import com.alee.api.jdk.Objects;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.laf.list.WebList;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.slider.WebSlider;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.MathUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.InsetsConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.slf4j.LoggerFactory;

public class CodeLinkGenerator
implements LinkGenerator {
    private static final ImmutableList<String> propertyNodes = new ImmutableList((Object[])new String[]{"component", "ui", "painter"});
    private static final String trueString = "true";
    private static final String falseString = "false";
    private static final ImmutableList<String> booleanContent = new ImmutableList((Object[])new String[]{"true", "false"});
    private static final ImmutableList<String> colorContent = new ImmutableList((Object[])new String[]{"foreground", "fg", "background", "bg", "color"});
    private static final ImmutableList<String> insetsContent = new ImmutableList((Object[])new String[]{"insets", "margin"});
    private static final ImmutableList<String> opacityContent = new ImmutableList((Object[])new String[]{"opacity", "transparency"});
    private static final ColorConverter colorConverter = new ColorConverter();
    private static final InsetsConverter insetsConverter = new InsetsConverter();
    private static final FloatConverter floatConverter = new FloatConverter();
    protected final Component parentComponent;
    protected Source src = null;
    protected String text = null;

    public CodeLinkGenerator(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public LinkGeneratorResult isLinkAtOffset(final RSyntaxTextArea source, int pos) {
        Element element;
        String code = source.getText();
        if (this.src == null || Objects.notEquals((Object)this.src, (Object)code)) {
            this.text = code;
            this.src = new Source((CharSequence)code);
            this.src.setLogger(null);
            this.src.fullSequentialParse();
        }
        if ((element = this.src.getEnclosingElement(pos)) == null) {
            return null;
        }
        Element parent = element.getParentElement();
        if (parent == null) {
            return null;
        }
        String name = element.getName();
        String parentName = parent.getName();
        if ("style".equals(name)) {
            Attributes attributes = element.getAttributes();
            for (Attribute attribute : attributes) {
                String attributeName;
                if (attribute.getBegin() >= pos || pos >= attribute.getEnd() || !(attributeName = attribute.getName()).equals("type")) continue;
                final Segment content = attribute.getValueSegment();
                String type = element.getAttributeValue("type");
                final ComponentDescriptor descriptor = StyleManager.getDescriptor(type);
                return new LinkGeneratorResult(){

                    public HyperlinkEvent execute() {
                        try {
                            final WebPopOver typeChooser = new WebPopOver(CodeLinkGenerator.this.parentComponent);
                            typeChooser.setCloseOnFocusLoss(true);
                            typeChooser.setPadding(5, 0, 5, 0);
                            List<ComponentDescriptor> types = StyleManager.getDescriptors();
                            final WebList typesList = new WebList(types);
                            typesList.setOpaque(false);
                            typesList.setVisibleRowCount(Math.min(10, types.size()));
                            typesList.setSelectOnHover(true);
                            typesList.setSelectedValue(descriptor);
                            final Runnable commitChanges = new Runnable(){

                                @Override
                                public void run() {
                                    String typeString = typesList.getSelectedValue().toString();
                                    source.replaceRange(typeString, content.getBegin(), content.getEnd());
                                    typeChooser.dispose();
                                }
                            };
                            typesList.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseReleased(MouseEvent e) {
                                    commitChanges.run();
                                }
                            });
                            typesList.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyReleased(KeyEvent e) {
                                    if (Hotkey.ENTER.isKeyTriggered(e)) {
                                        commitChanges.run();
                                    }
                                }
                            });
                            WebScrollPane scrollPane = new WebScrollPane(StyleId.scrollpanePopup, typesList);
                            typeChooser.add(scrollPane);
                            int position = (content.getBegin() + content.getEnd()) / 2;
                            Rectangle wb = source.getUI().modelToView((JTextComponent)source, position);
                            typeChooser.show((Component)source, wb.x, wb.y, wb.width, wb.height, PopOverDirection.down);
                            return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                        }
                        catch (BadLocationException e) {
                            LoggerFactory.getLogger(CodeLinkGenerator.class).error(e.toString(), (Throwable)e);
                            return null;
                        }
                    }

                    public int getSourceOffset() {
                        return content.getBegin();
                    }
                };
            }
        } else if (propertyNodes.contains((Object)parentName)) {
            Insets insets;
            final Segment content = element.getContent();
            final String contentString = content.toString();
            if (booleanContent.contains((Object)contentString)) {
                return new LinkGeneratorResult(){

                    public HyperlinkEvent execute() {
                        String str = contentString.equals(CodeLinkGenerator.trueString) ? CodeLinkGenerator.falseString : CodeLinkGenerator.trueString;
                        source.replaceRange(str, content.getBegin(), content.getEnd());
                        return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                    }

                    public int getSourceOffset() {
                        return content.getBegin();
                    }
                };
            }
            if (this.contains(name.toLowerCase(Locale.ROOT), (List<String>)colorContent)) {
                final Color color = (Color)colorConverter.fromString(contentString);
                if (color != null || contentString.equals("null")) {
                    return new LinkGeneratorResult(){

                        public HyperlinkEvent execute() {
                            try {
                                WebPopOver colorChooser = new WebPopOver(CodeLinkGenerator.this.parentComponent);
                                colorChooser.setCloseOnFocusLoss(true);
                                final WebColorChooserPanel colorChooserPanel = new WebColorChooserPanel(false);
                                colorChooserPanel.setColor(color != null ? color : Color.WHITE);
                                colorChooserPanel.addChangeListener(new ChangeListener(){
                                    private int length;
                                    {
                                        this.length = content.getEnd() - content.getBegin();
                                    }

                                    @Override
                                    public void stateChanged(ChangeEvent e) {
                                        Color newColor = colorChooserPanel.getColor();
                                        if (color == null || newColor != null && !newColor.equals(color)) {
                                            String colorString = colorConverter.toString((Object)newColor);
                                            source.replaceRange(colorString, content.getBegin(), content.getBegin() + this.length);
                                            this.length = colorString.length();
                                        }
                                    }
                                });
                                colorChooser.add(colorChooserPanel);
                                int position = (content.getBegin() + content.getEnd()) / 2;
                                Rectangle wb = source.getUI().modelToView((JTextComponent)source, position);
                                colorChooser.show((Component)source, wb.x, wb.y, wb.width, wb.height, PopOverDirection.down);
                                return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                            }
                            catch (BadLocationException e) {
                                LoggerFactory.getLogger(CodeLinkGenerator.class).error(e.toString(), (Throwable)e);
                                return null;
                            }
                        }

                        public int getSourceOffset() {
                            return content.getBegin();
                        }
                    };
                }
            } else if (this.contains(name.toLowerCase(Locale.ROOT), (List<String>)opacityContent)) {
                final Float f = (Float)floatConverter.fromString(contentString);
                if (f != null) {
                    return new LinkGeneratorResult(){

                        public HyperlinkEvent execute() {
                            try {
                                WebPopOver opacityChooser = new WebPopOver(CodeLinkGenerator.this.parentComponent);
                                opacityChooser.setCloseOnFocusLoss(true);
                                int value = MathUtils.limit((int)0, (int)Math.round(1000.0f * f.floatValue()), (int)1000);
                                final WebSlider slider = new WebSlider(0, 0, 1000, value);
                                slider.setPadding(10);
                                slider.setPaintTicks(true);
                                slider.setSnapToTicks(true);
                                slider.setPaintLabels(false);
                                slider.setMajorTickSpacing(50);
                                slider.setMinorTickSpacing(10);
                                slider.setPreferredWidth(500);
                                slider.addChangeListener(new ChangeListener(){
                                    private int length;
                                    {
                                        this.length = content.getEnd() - content.getBegin();
                                    }

                                    @Override
                                    public void stateChanged(ChangeEvent e) {
                                        String floatString = floatConverter.toString((Object)Float.valueOf((float)slider.getValue() / 1000.0f));
                                        source.replaceRange(floatString, content.getBegin(), content.getBegin() + this.length);
                                        this.length = floatString.length();
                                    }
                                });
                                opacityChooser.add(slider);
                                int position = (content.getBegin() + content.getEnd()) / 2;
                                Rectangle wb = source.getUI().modelToView((JTextComponent)source, position);
                                opacityChooser.show((Component)source, wb.x, wb.y, wb.width, wb.height, PopOverDirection.down);
                                return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                            }
                            catch (BadLocationException e) {
                                LoggerFactory.getLogger(CodeLinkGenerator.class).error(e.toString(), (Throwable)e);
                                return null;
                            }
                        }

                        public int getSourceOffset() {
                            return content.getBegin();
                        }
                    };
                }
            } else if (this.contains(name.toLowerCase(Locale.ROOT), (List<String>)insetsContent) && (insets = (Insets)insetsConverter.fromString(contentString)) != null) {
                return null;
            }
        }
        return null;
    }

    protected boolean contains(String text, List<String> tokens) {
        for (String token : tokens) {
            if (!text.contains(token)) continue;
            return true;
        }
        return false;
    }
}

