/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.svg;

import com.alee.api.annotations.NotNull;
import com.alee.extended.svg.SvgIcon;
import com.alee.managers.icon.data.IconAdjustment;
import com.alee.utils.ColorUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.collection.ImmutableList;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.util.List;

public abstract class AbstractSvgColorAdjustment
implements IconAdjustment<SvgIcon> {
    protected static final List<String> ATTRIBUTES = new ImmutableList((Object[])new String[]{"stroke", "fill", "stop-color"});

    @Override
    public void apply(@NotNull SvgIcon icon) {
        List<SVGElement> elements = icon.find("*[" + TextUtils.listToString(ATTRIBUTES, (String)",") + "]");
        for (SVGElement element : elements) {
            for (String attribute : ATTRIBUTES) {
                this.apply(icon, element, attribute);
            }
        }
    }

    protected void apply(@NotNull SvgIcon icon, @NotNull SVGElement element, @NotNull String attribute) {
        Color color;
        StyleAttribute hexColor;
        if (icon.hasAttribute(element, attribute) && (hexColor = icon.getAttribute(element, attribute)) != null && (color = hexColor.getColorValue()) != null) {
            icon.setAttribute(element, attribute, ColorUtils.toHex((Color)this.adjustColor(icon, element, attribute, color)));
        }
    }

    @NotNull
    protected abstract Color adjustColor(@NotNull SvgIcon var1, @NotNull SVGElement var2, @NotNull String var3, @NotNull Color var4);
}

