/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.svg;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.svg.AbstractSvgAttributeAdjustment;
import com.alee.extended.svg.SvgIcon;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.Scale;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.xml.StyleAttribute;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Dimension;
import java.awt.geom.Point2D;

@XStreamAlias(value="SvgTransform")
public class SvgTransform
extends AbstractSvgAttributeAdjustment {
    @XStreamAsAttribute
    @Nullable
    protected Point2D translate;
    @XStreamAsAttribute
    @Nullable
    protected Scale scale;
    @XStreamAsAttribute
    @Nullable
    protected Double rotate;

    public SvgTransform() {
        this(null, null, null, null);
    }

    public SvgTransform(@Nullable Point2D translate) {
        this(null, translate, null, null);
    }

    public SvgTransform(@Nullable Scale scale) {
        this(null, null, scale, null);
    }

    public SvgTransform(@Nullable Double rotate) {
        this(null, null, null, rotate);
    }

    public SvgTransform(@Nullable Point2D translate, @Nullable Scale scale, @Nullable Double rotate) {
        this(null, translate, scale, rotate);
    }

    public SvgTransform(@Nullable String selector) {
        this(selector, null, null, null);
    }

    public SvgTransform(@Nullable String selector, @Nullable Point2D translate) {
        this(selector, translate, null, null);
    }

    public SvgTransform(@Nullable String selector, @Nullable Scale scale) {
        this(selector, null, scale, null);
    }

    public SvgTransform(@Nullable String selector, @Nullable Double rotate) {
        this(selector, null, null, rotate);
    }

    public SvgTransform(@Nullable String selector, @Nullable Point2D translate, @Nullable Scale scale, @Nullable Double rotate) {
        super(selector);
        this.translate = translate;
        this.scale = scale;
        this.rotate = rotate;
    }

    @Override
    @NotNull
    protected String getAttribute(@NotNull SvgIcon icon) {
        return "transform";
    }

    @Override
    @Nullable
    protected String getValue(@NotNull SvgIcon icon, @NotNull SVGElement element, @Nullable StyleAttribute attribute) {
        String transform;
        if (this.translate != null || this.scale != null || this.rotate != null) {
            Dimension ps;
            transform = "";
            if (this.translate != null) {
                transform = transform + "translate(" + this.translate.getX() + " " + this.translate.getY() + ")";
            }
            if (this.scale != null) {
                if (TextUtils.notEmpty((String)transform)) {
                    transform = transform + " ";
                }
                ps = icon.getPreferredSize();
                double x = ((double)ps.width - (double)ps.width * this.scale.getX()) / 2.0;
                double y = ((double)ps.height - (double)ps.height * this.scale.getY()) / 2.0;
                transform = transform + "translate(" + x + " " + y + ") scale(" + this.scale.getX() + " " + this.scale.getY() + ")";
            }
            if (this.rotate != null) {
                if (TextUtils.notEmpty((String)transform)) {
                    transform = transform + " ";
                }
                ps = icon.getPreferredSize();
                transform = transform + "rotate(" + this.rotate + " " + ps.width / 2 + " " + ps.height / 2 + ")";
            }
        } else {
            transform = "none";
        }
        return transform;
    }
}

