/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.syntax;

import com.alee.api.annotations.NotNull;
import com.alee.extended.syntax.PresetType;
import com.alee.extended.syntax.SyntaxTheme;
import com.alee.extended.syntax.WebSyntaxArea;
import com.alee.utils.FileUtils;
import java.awt.Insets;
import java.io.File;
import java.util.Locale;

public enum SyntaxPreset {
    base(PresetType.settings){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setAntiAliasingEnabled(true);
            syntaxArea.setUseFocusableTips(true);
            syntaxArea.setTabSize(4);
            syntaxArea.setCodeFoldingEnabled(true);
            syntaxArea.setPaintTabLines(false);
            syntaxArea.setWhitespaceVisible(false);
            syntaxArea.setEOLMarkersVisible(false);
        }
    }
    ,
    size(PresetType.style){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setRows(4);
            syntaxArea.setColumns(1);
        }
    }
    ,
    margin(PresetType.style){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setMargin(new Insets(5, 5, 5, 5));
        }
    }
    ,
    historyLimit(PresetType.settings){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.getUndoManager().setLimit(50);
        }
    }
    ,
    viewable(PresetType.settings){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setEditable(false);
        }
    }
    ,
    editable(PresetType.settings){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setEditable(true);
        }
    }
    ,
    hideMenu(PresetType.settings){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setPopupMenu(null);
        }
    }
    ,
    opaque(PresetType.style){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setOpaque(true);
        }
    }
    ,
    nonOpaque(PresetType.style){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setOpaque(false);
        }
    }
    ,
    java(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/java");
        }
    }
    ,
    xml(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/xml");
        }
    }
    ,
    html(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/html");
        }
    }
    ,
    css(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/css");
        }
    }
    ,
    js(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/javascript");
        }
    }
    ,
    php(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/php");
        }
    }
    ,
    sql(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/sql");
        }
    }
    ,
    none(PresetType.syntax){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            syntaxArea.setSyntaxEditingStyle("text/plain");
        }
    }
    ,
    ideaTheme(PresetType.theme){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            SyntaxTheme.idea.apply(syntaxArea);
        }
    }
    ,
    darkTheme(PresetType.theme){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            SyntaxTheme.dark.apply(syntaxArea);
        }
    }
    ,
    vsTheme(PresetType.theme){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            SyntaxTheme.vs.apply(syntaxArea);
        }
    }
    ,
    eclipseTheme(PresetType.theme){

        @Override
        public void apply(@NotNull WebSyntaxArea syntaxArea) {
            SyntaxTheme.eclipse.apply(syntaxArea);
        }
    };

    @NotNull
    private final PresetType type;

    private SyntaxPreset(PresetType type) {
        this.type = type;
    }

    @NotNull
    public PresetType getType() {
        return this.type;
    }

    public abstract void apply(@NotNull WebSyntaxArea var1);

    @NotNull
    public static SyntaxPreset getSyntaxPreset(@NotNull File file) {
        return SyntaxPreset.getSyntaxPreset(file.getName());
    }

    @NotNull
    public static SyntaxPreset getSyntaxPreset(@NotNull String file) {
        String ext;
        String fe = FileUtils.getFileExtPart((String)file, (boolean)false);
        String string = ext = fe.length() > 0 ? fe.toLowerCase(Locale.ROOT) : file;
        SyntaxPreset preset = ext.contains("java") ? java : (ext.contains("xml") ? xml : (ext.contains("htm") ? html : (ext.contains("css") ? css : (ext.contains("js") || ext.contains("javascript") ? js : (ext.contains("php") ? php : (ext.contains("sql") ? sql : none))))));
        return preset;
    }
}

