/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.syntax;

import com.alee.api.annotations.NotNull;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.slf4j.LoggerFactory;

public enum SyntaxTheme {
    idea,
    dark,
    vs,
    eclipse;


    @NotNull
    public Icon getIcon() {
        return new ImageIcon(SyntaxTheme.class.getResource("icons/" + (Object)((Object)this) + ".png"));
    }

    @NotNull
    public String getName() {
        String name;
        switch (this) {
            default: {
                name = "IntelliJ IDEA";
                break;
            }
            case dark: {
                name = "Dark";
                break;
            }
            case vs: {
                name = "Visual Studio";
                break;
            }
            case eclipse: {
                name = "Eclipse";
            }
        }
        return name;
    }

    public void apply(@NotNull RSyntaxTextArea syntaxArea) {
        try {
            Theme.load((InputStream)SyntaxTheme.class.getResourceAsStream("themes/" + (Object)((Object)this) + ".xml")).apply(syntaxArea);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(SyntaxTheme.class).error(e.toString(), (Throwable)e);
        }
    }
}

