/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.syntax;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.DocumentChangeBehavior;
import com.alee.extended.syntax.PresetType;
import com.alee.extended.syntax.SyntaxPreset;
import com.alee.extended.syntax.WebSyntaxScrollPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.style.Skin;
import com.alee.managers.style.SkinListener;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.skin.dark.WebDarkSkin;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.DocumentEventMethods;
import com.alee.utils.swing.extensions.DocumentEventMethodsImpl;
import com.alee.utils.swing.extensions.DocumentEventRunnable;
import com.alee.utils.swing.extensions.EventMethods;
import com.alee.utils.swing.extensions.EventMethodsImpl;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.util.List;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RUndoManager;

public class WebSyntaxArea
extends RSyntaxTextArea
implements DocumentEventMethods<WebSyntaxArea>,
EventMethods {
    protected RUndoManager undoManager;
    @Nullable
    protected SyntaxPreset themePreset;

    public WebSyntaxArea(SyntaxPreset ... presets) {
        this.initialize(presets);
    }

    public WebSyntaxArea(@Nullable String text, SyntaxPreset ... presets) {
        super(text);
        this.initialize(presets);
    }

    public WebSyntaxArea(int rows, int cols, SyntaxPreset ... presets) {
        super(rows, cols);
        this.initialize(presets);
    }

    public WebSyntaxArea(@Nullable String text, int rows, int cols, SyntaxPreset ... presets) {
        super(text, rows, cols);
        this.initialize(presets);
    }

    public WebSyntaxArea(int textMode, SyntaxPreset ... presets) {
        super(textMode);
        this.initialize(presets);
    }

    protected void initialize(SyntaxPreset ... presets) {
        this.applyPresets(presets);
        if (this.themePreset == null) {
            this.applyPresets(StyleManager.getSkin() instanceof WebDarkSkin ? SyntaxPreset.darkTheme : SyntaxPreset.ideaTheme);
            StyleManager.addSkinListener(new SkinListener(){

                @Override
                public void skinChanged(@Nullable Skin previous, @NotNull Skin current) {
                    WebSyntaxArea.this.applyPresets(StyleManager.getSkin() instanceof WebDarkSkin ? SyntaxPreset.darkTheme : SyntaxPreset.ideaTheme);
                }
            });
        }
        this.clearHistory();
        this.onKeyPress(Hotkey.CTRL_SHIFT_Z, new KeyEventRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                WebSyntaxArea.this.redoLastAction();
            }
        });
    }

    @NotNull
    protected RUndoManager createUndoManager() {
        this.undoManager = super.createUndoManager();
        return this.undoManager;
    }

    @NotNull
    public RUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void clearHistory() {
        this.undoManager.discardAllEdits();
    }

    @NotNull
    public WebSyntaxScrollPane createScroll() {
        return this.createScroll(StyleId.syntaxareaScroll);
    }

    @NotNull
    public WebSyntaxScrollPane createScroll(@NotNull StyleId id) {
        WebSyntaxScrollPane scrollPane = new WebSyntaxScrollPane(id, this);
        if (this.themePreset != null) {
            this.applyPresetImpl(this.themePreset);
        }
        return scrollPane;
    }

    @Nullable
    public SyntaxPreset getThemePreset() {
        return this.themePreset;
    }

    public void applyPresets(SyntaxPreset ... presets) {
        for (SyntaxPreset preset : presets) {
            this.applyPresetImpl(preset);
        }
    }

    public void applyPresets(@NotNull List<SyntaxPreset> presets) {
        for (SyntaxPreset preset : presets) {
            this.applyPresetImpl(preset);
        }
    }

    protected void applyPresetImpl(@NotNull SyntaxPreset preset) {
        boolean opaque = this.isOpaque();
        preset.apply(this);
        if (preset.getType() == PresetType.theme) {
            this.themePreset = preset;
            this.setOpaque(opaque);
        }
    }

    @Override
    @NotNull
    public DocumentChangeBehavior<WebSyntaxArea> onChange(@NotNull DocumentEventRunnable<WebSyntaxArea> runnable) {
        return DocumentEventMethodsImpl.onChange(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress((Component)((Object)this), mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseEnter(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseEnter((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseExit(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseExit((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag((Component)((Object)this), mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick((Component)((Object)this), mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDoubleClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDoubleClick((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMenuTrigger(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMenuTrigger((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType((Component)((Object)this), hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress((Component)((Object)this), hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease((Component)((Object)this), hotkey, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusGain(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusGain((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusLoss(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusLoss((Component)((Object)this), runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart((Component)((Object)this), shift, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart((Component)((Object)this), shift, mouseButton, runnable);
    }
}

