/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.ExTreeDataProvider;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeNode;
import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractExTreeDataProvider<N extends UniqueNode>
implements ExTreeDataProvider<N> {
    @Nullable
    protected transient Filter<N> filter = null;
    @Nullable
    protected transient Comparator<N> comparator = null;

    @Override
    @Nullable
    public Filter<N> getChildrenFilter(@NotNull N parent, @NotNull List<N> children) {
        return this.filter;
    }

    public void setChildrenFilter(@Nullable Filter<N> filter) {
        this.filter = filter;
    }

    @Override
    @Nullable
    public Comparator<N> getChildrenComparator(@NotNull N parent, @NotNull List<N> children) {
        return this.comparator;
    }

    public void setChildrenComparator(@Nullable Comparator<N> comparator) {
        this.comparator = comparator;
    }

    @NotNull
    public WebTreeModel<N> createPlainModel() {
        Object root = this.getRoot();
        this.loadPlainChildren(root);
        return new WebTreeModel(root);
    }

    protected void loadPlainChildren(@NotNull N parent) {
        List<N> children = this.getChildren(parent);
        ArrayList filtered = CollectionUtils.filter(children, this.getChildrenFilter(parent, children));
        List sorted = CollectionUtils.sort(children, this.getChildrenComparator(parent, filtered));
        for (UniqueNode child : sorted) {
            ((WebTreeNode)parent).add(child);
            this.loadPlainChildren(child);
        }
    }
}

