/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.NodesDropCallback;
import com.alee.extended.tree.NodesDropHandler;
import com.alee.extended.tree.NodesTransferable;
import com.alee.extended.tree.TreeDropHandler;
import com.alee.laf.tree.NodesAcceptPolicy;
import com.alee.laf.tree.NodesRowComparator;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeNode;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.MutableTreeNode;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeTransferHandler<N extends UniqueNode, T extends WebTree<N>, M extends WebTreeModel<N>>
extends TransferHandler {
    @NotNull
    protected NodesAcceptPolicy nodesAcceptPolicy = NodesAcceptPolicy.ancestors;
    protected boolean expandSingleNode = false;
    protected boolean expandMultipleNodes = false;
    @NotNull
    protected List<? extends TreeDropHandler> dropHandlers = this.createDropHandlers();
    @Nullable
    protected List<N> draggedNodes;
    @Nullable
    protected Map<String, List<Integer>> draggedNodeIndices;

    @NotNull
    protected List<? extends TreeDropHandler> createDropHandlers() {
        return CollectionUtils.asList((Object[])new NodesDropHandler[]{new NodesDropHandler()});
    }

    @NotNull
    public NodesAcceptPolicy getNodesAcceptPolicy() {
        return this.nodesAcceptPolicy;
    }

    public void setNodesAcceptPolicy(@NotNull NodesAcceptPolicy policy) {
        this.nodesAcceptPolicy = policy;
    }

    public boolean isExpandSingleNode() {
        return this.expandSingleNode;
    }

    public void setExpandSingleNode(boolean expand) {
        this.expandSingleNode = expand;
    }

    public boolean isExpandMultipleNodes() {
        return this.expandMultipleNodes;
    }

    public void setExpandMultipleNodes(boolean expand) {
        this.expandMultipleNodes = expand;
    }

    @Override
    public abstract int getSourceActions(@NotNull JComponent var1);

    protected boolean isMoveAction(int action) {
        return (action & 2) == 2;
    }

    protected boolean isCopyAction(int action) {
        return (action & 1) == 1;
    }

    @Override
    @Nullable
    protected Transferable createTransferable(@NotNull JComponent c) {
        Transferable transferable = null;
        WebTree tree = (WebTree)c;
        List nodes = tree.getSelectedNodes();
        if (!nodes.isEmpty() && !nodes.contains(tree.getRootNode())) {
            this.getNodesAcceptPolicy().filter(tree, nodes);
            CollectionUtils.sort(nodes, new NodesRowComparator(tree));
            WebTreeModel model = (WebTreeModel)tree.getModel();
            if (model != null && this.canBeDragged(tree, model, nodes)) {
                ArrayList<UniqueNode> copies = new ArrayList<UniqueNode>();
                for (UniqueNode node : nodes) {
                    copies.add(this.copy(tree, model, node));
                }
                this.draggedNodes = nodes;
                this.draggedNodeIndices = new HashMap<String, List<Integer>>(1);
                for (UniqueNode node : this.draggedNodes) {
                    UniqueNode parent = (UniqueNode)node.getParent();
                    if (parent == null) continue;
                    List<Integer> indices = this.draggedNodeIndices.get(parent.getId());
                    if (indices == null) {
                        indices = new ArrayList<Integer>(1);
                        this.draggedNodeIndices.put(parent.getId(), indices);
                    }
                    indices.add(parent.getIndex(node));
                }
                transferable = this.createTransferable(tree, model, copies);
            }
        }
        return transferable;
    }

    protected abstract boolean canBeDragged(@NotNull T var1, @NotNull M var2, @NotNull List<N> var3);

    @NotNull
    protected abstract N copy(@NotNull T var1, @NotNull M var2, @NotNull N var3);

    @NotNull
    protected Transferable createTransferable(@NotNull T tree, @NotNull M model, @NotNull List<N> nodes) {
        return new NodesTransferable<N>(nodes);
    }

    @Override
    public boolean canImport(@NotNull TransferHandler.TransferSupport support) {
        boolean canImport = false;
        if (support.isDrop()) {
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            WebTree tree = (WebTree)support.getComponent();
            WebTreeModel model = (WebTreeModel)tree.getModel();
            UniqueNode destination = (UniqueNode)tree.getNodeForPath(dl.getPath());
            if (model != null && destination != null && this.canDropTo(support, tree, model, destination)) {
                boolean validMove = true;
                if (this.isMoveAction(support.getDropAction()) && this.draggedNodes != null) {
                    for (UniqueNode node : this.draggedNodes) {
                        if (node != destination && !node.isNodeDescendant(destination)) continue;
                        validMove = false;
                        break;
                    }
                }
                if (validMove) {
                    TreeDropHandler<UniqueNode, WebTree, WebTreeModel> dropHandler = this.getDropHandler(support, tree, model, destination);
                    boolean canBeDropped = dropHandler != null && dropHandler.canDrop(support, tree, model, destination);
                    support.setShowDropLocation(canBeDropped);
                    canImport = canBeDropped;
                }
            }
        }
        return canImport;
    }

    protected boolean canDropTo(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination) {
        return true;
    }

    @Nullable
    protected TreeDropHandler<N, T, M> getDropHandler(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination) {
        TreeDropHandler dropHandler = null;
        for (TreeDropHandler treeDropHandler : this.dropHandlers) {
            List<DataFlavor> flavors = treeDropHandler.getSupportedFlavors();
            if (!CollectionUtils.notEmpty(flavors)) continue;
            for (DataFlavor flavor : flavors) {
                if (!support.isDataFlavorSupported(flavor)) continue;
                dropHandler = treeDropHandler;
                break;
            }
            if (dropHandler == null) continue;
            break;
        }
        return dropHandler;
    }

    @Override
    public boolean importData(@NotNull TransferHandler.TransferSupport support) {
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        WebTree tree = (WebTree)support.getComponent();
        WebTreeModel model = (WebTreeModel)tree.getModel();
        UniqueNode destination = (UniqueNode)tree.getNodeForPath(dl.getPath());
        int dropIndex = dl.getChildIndex();
        return model != null && destination != null && this.prepareDropOperation(support, tree, model, destination, dropIndex);
    }

    protected boolean prepareDropOperation(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int dropIndex) {
        if (!((WebTree)tree).isExpanded(destination)) {
            ((WebTree)tree).expandNode(destination);
        }
        int adjustedDropIndex = this.getAdjustedDropIndex(support, tree, model, destination, dropIndex);
        return this.performDropOperation(support, tree, model, destination, adjustedDropIndex);
    }

    protected int getAdjustedDropIndex(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int dropIndex) {
        int adjustedDropIndex;
        int n = adjustedDropIndex = dropIndex == -1 ? ((WebTreeNode)destination).getChildCount() : dropIndex;
        if (this.isMoveAction(support.getDropAction()) && this.draggedNodeIndices != null && this.draggedNodeIndices.containsKey(((UniqueNode)destination).getId())) {
            int initialIndex = adjustedDropIndex;
            for (Integer index : this.draggedNodeIndices.get(((UniqueNode)destination).getId())) {
                if (index >= initialIndex) continue;
                --adjustedDropIndex;
            }
        }
        return adjustedDropIndex;
    }

    protected boolean performDropOperation(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int index) {
        boolean dropApproved = false;
        TreeDropHandler<N, T, M> handler = this.getDropHandler(support, tree, model, destination);
        if (handler != null && (dropApproved = handler.prepareDrop(support, tree, model, destination, index))) {
            NodesDropCallback<N> callback = this.createNodesDropCallback(support, tree, model, destination, index);
            handler.performDrop(support, tree, model, destination, index, callback);
        }
        return dropApproved;
    }

    @NotNull
    protected NodesDropCallback<N> createNodesDropCallback(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int index) {
        return new NodesDropCallback<N>((WebTreeModel)model, (UniqueNode)destination, index, support, (WebTree)tree){
            private final List<N> dropped = new ArrayList();
            final /* synthetic */ WebTreeModel val$model;
            final /* synthetic */ UniqueNode val$destination;
            final /* synthetic */ int val$index;
            final /* synthetic */ TransferHandler.TransferSupport val$support;
            final /* synthetic */ WebTree val$tree;
            {
                this.val$model = webTreeModel;
                this.val$destination = uniqueNode;
                this.val$index = n;
                this.val$support = transferSupport;
                this.val$tree = webTree;
            }

            @Override
            public void dropped(N ... nodes) {
                CoreSwingUtils.invokeLater((Runnable)new Runnable((UniqueNode[])nodes){
                    final /* synthetic */ UniqueNode[] val$nodes;
                    {
                        this.val$nodes = uniqueNodeArray;
                    }

                    @Override
                    public void run() {
                        Collections.addAll(dropped, this.val$nodes);
                        val$model.insertNodesInto(this.val$nodes, val$destination, val$index);
                    }
                });
            }

            @Override
            public void dropped(final @NotNull List<N> nodes) {
                CoreSwingUtils.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        dropped.addAll(nodes);
                        val$model.insertNodesInto(nodes, val$destination, val$index);
                    }
                });
            }

            @Override
            public void completed() {
                AbstractTreeTransferHandler.this.dropCompleted(this.val$support, this.val$tree, this.val$model, this.val$destination, this.val$index, this.dropped);
            }

            @Override
            public void failed(@NotNull Throwable cause) {
                AbstractTreeTransferHandler.this.dropFailed(this.val$support, this.val$tree, this.val$model, this.val$destination, this.val$index, this.dropped, cause);
            }
        };
    }

    protected void dropCompleted(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int index, @NotNull List<N> dropped) {
        this.finishDrop(support, tree, model, destination, index, dropped);
    }

    protected void dropFailed(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int index, @NotNull List<N> dropped, @NotNull Throwable cause) {
        LoggerFactory.getLogger(AbstractTreeTransferHandler.class).error("Unable to perform drop operation", cause);
        this.finishDrop(support, tree, model, destination, index, dropped);
    }

    protected void finishDrop(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int index, final @NotNull List<N> dropped) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable((WebTree)tree){
            final /* synthetic */ WebTree val$tree;
            {
                this.val$tree = webTree;
            }

            @Override
            public void run() {
                if (dropped.size() > 0) {
                    if (AbstractTreeTransferHandler.this.expandSingleNode && dropped.size() == 1) {
                        this.val$tree.expandNode((MutableTreeNode)dropped.get(0));
                    } else if (AbstractTreeTransferHandler.this.expandMultipleNodes) {
                        for (UniqueNode node : dropped) {
                            this.val$tree.expandNode(node);
                        }
                    }
                    this.val$tree.setSelectedNodes(dropped);
                }
            }
        });
    }

    @Override
    protected void exportDone(@NotNull JComponent source, @NotNull Transferable data, int action) {
        if (this.draggedNodes != null && this.isMoveAction(action)) {
            WebTree tree = (WebTree)source;
            this.removeTreeNodes(tree, this.draggedNodes);
        }
        this.draggedNodeIndices = null;
        this.draggedNodes = null;
    }

    protected void removeTreeNodes(@NotNull T tree, @NotNull List<N> nodesToRemove) {
        WebTreeModel model = (WebTreeModel)((WebTree)tree).getModel();
        if (model != null) {
            model.removeNodesFromParent(nodesToRemove);
        }
    }

    @NotNull
    protected <O> List<O> extract(@NotNull List<N> nodes) {
        ArrayList objects = new ArrayList(nodes.size());
        for (UniqueNode node : nodes) {
            objects.add(node.getUserObject());
        }
        return objects;
    }

    @NotNull
    public String toString() {
        return this.getClass().getName();
    }
}

