/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.extended.tree.AbstractTreeTransferHandler;
import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.WebTree;
import com.alee.managers.task.TaskManager;
import java.util.List;
import javax.swing.TransferHandler;

public abstract class AsyncTreeTransferHandler<N extends AsyncUniqueNode, T extends WebAsyncTree<N>, M extends AsyncTreeModel<N>>
extends AbstractTreeTransferHandler<N, T, M> {
    protected boolean allowUncheckedDrop = false;

    public boolean isAllowUncheckedDrop() {
        return this.allowUncheckedDrop;
    }

    public void setAllowUncheckedDrop(boolean allowUncheckedDrop) {
        this.allowUncheckedDrop = allowUncheckedDrop;
    }

    @Override
    protected boolean canDropTo(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination) {
        return !((AsyncUniqueNode)destination).isLoading() && !((AsyncUniqueNode)destination).isFailed();
    }

    @Override
    protected boolean prepareDropOperation(final @NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int dropIndex) {
        boolean prepared;
        if (this.allowUncheckedDrop) {
            AsyncTreeDataProvider dataProvider = ((WebAsyncTree)tree).getDataProvider();
            if (dataProvider != null) {
                if (((AsyncUniqueNode)destination).isLoaded()) {
                    if (!((WebTree)tree).isExpanded(destination)) {
                        ((WebTree)tree).expandNode(destination);
                    }
                    int adjustedDropIndex = this.getAdjustedDropIndex(support, tree, model, destination, dropIndex);
                    TaskManager.execute((String)dataProvider.getThreadGroupId(), (Runnable)new Runnable((WebAsyncTree)tree, (AsyncTreeModel)model, (AsyncUniqueNode)destination, adjustedDropIndex){
                        final /* synthetic */ WebAsyncTree val$tree;
                        final /* synthetic */ AsyncTreeModel val$model;
                        final /* synthetic */ AsyncUniqueNode val$destination;
                        final /* synthetic */ int val$adjustedDropIndex;
                        {
                            this.val$tree = webAsyncTree;
                            this.val$model = asyncTreeModel;
                            this.val$destination = asyncUniqueNode;
                            this.val$adjustedDropIndex = n;
                        }

                        @Override
                        public void run() {
                            AsyncTreeTransferHandler.this.performDropOperation(support, this.val$tree, this.val$model, this.val$destination, this.val$adjustedDropIndex);
                        }
                    });
                } else {
                    ((WebAsyncTree)tree).addAsyncTreeListener(new AsyncTreeAdapter<N>((AsyncUniqueNode)destination, dataProvider, support, (WebAsyncTree)tree, (AsyncTreeModel)model){
                        final /* synthetic */ AsyncUniqueNode val$destination;
                        final /* synthetic */ AsyncTreeDataProvider val$dataProvider;
                        final /* synthetic */ TransferHandler.TransferSupport val$support;
                        final /* synthetic */ WebAsyncTree val$tree;
                        final /* synthetic */ AsyncTreeModel val$model;
                        {
                            this.val$destination = asyncUniqueNode;
                            this.val$dataProvider = asyncTreeDataProvider;
                            this.val$support = transferSupport;
                            this.val$tree = webAsyncTree;
                            this.val$model = asyncTreeModel;
                        }

                        @Override
                        public void loadCompleted(@NotNull N parent, @NotNull List<N> children) {
                            if (parent == this.val$destination) {
                                TaskManager.execute((String)this.val$dataProvider.getThreadGroupId(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncTreeTransferHandler.this.performDropOperation(val$support, val$tree, val$model, val$destination, val$destination.getChildCount());
                                    }
                                });
                                this.val$tree.removeAsyncTreeListener(this);
                            }
                        }

                        @Override
                        public void loadFailed(@NotNull N parent, @NotNull Throwable cause) {
                            if (parent == this.val$destination) {
                                this.val$tree.removeAsyncTreeListener(this);
                            }
                        }
                    });
                    ((WebAsyncTree)tree).reloadNode(destination);
                }
                prepared = true;
            } else {
                prepared = false;
            }
        } else {
            if (!((AsyncUniqueNode)destination).isLoaded()) {
                ((WebAsyncTree)tree).reloadNodeSync(destination);
            }
            prepared = ((AsyncUniqueNode)destination).isLoaded() && this.performDropOperation(support, tree, model, destination, this.getAdjustedDropIndex(support, tree, model, destination, dropIndex));
        }
        return prepared;
    }
}

