/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.CheckStateChange;
import com.alee.extended.tree.CheckStateChangeListener;
import com.alee.extended.tree.NodesPositionComparator;
import com.alee.extended.tree.TreeCheckingModel;
import com.alee.extended.tree.WebCheckBoxTree;
import com.alee.laf.checkbox.CheckState;
import com.alee.laf.tree.NodesAcceptPolicy;
import com.alee.laf.tree.WebTree;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.tree.MutableTreeNode;

public class DefaultTreeCheckingModel<N extends MutableTreeNode, T extends WebCheckBoxTree<N>>
implements TreeCheckingModel<N> {
    @NotNull
    protected final T checkBoxTree;
    @NotNull
    protected Map<N, CheckState> nodeCheckStates;
    @NotNull
    protected EventListenerList listeners;
    @NotNull
    protected Comparator<N> nodesComparator;

    public DefaultTreeCheckingModel(@NotNull T checkBoxTree) {
        this.checkBoxTree = checkBoxTree;
        this.nodeCheckStates = new WeakHashMap<N, CheckState>();
        this.listeners = new EventListenerList();
        this.nodesComparator = this.createNodesComparator();
    }

    @NotNull
    protected Comparator<N> createNodesComparator() {
        return new NodesPositionComparator();
    }

    @Override
    @NotNull
    public List<N> getNodes(@NotNull CheckState state, @NotNull NodesAcceptPolicy policy) {
        ArrayList<Object> collected = new ArrayList<Object>();
        if (state == CheckState.checked || state == CheckState.mixed) {
            for (Map.Entry<N, CheckState> entry : this.nodeCheckStates.entrySet()) {
                if (entry.getValue() != state) continue;
                collected.add(entry.getKey());
            }
        } else {
            ArrayList<Object> runthrough = new ArrayList<Object>();
            runthrough.add(((WebTree)this.checkBoxTree).getRootNode());
            while (!runthrough.isEmpty()) {
                boolean unchecked;
                MutableTreeNode node = (MutableTreeNode)runthrough.remove(0);
                CheckState nodeState = this.nodeCheckStates.get(node);
                boolean bl = unchecked = nodeState == null || nodeState == CheckState.unchecked;
                if (unchecked) {
                    collected.add(node);
                }
                for (int i = 0; i < this.getChildCount(node); ++i) {
                    runthrough.add(this.getChildAt(node, i));
                }
            }
        }
        policy.filter((JTree)this.checkBoxTree, collected);
        Collections.sort(collected, this.nodesComparator);
        return collected;
    }

    @Override
    @NotNull
    public CheckState getCheckState(@NotNull N node) {
        CheckState checkState = this.nodeCheckStates.get(node);
        return checkState != null ? checkState : CheckState.unchecked;
    }

    @Override
    public void setChecked(@NotNull N node, boolean checked) {
        boolean collectChanges = this.listeners.getListenerCount(CheckStateChangeListener.class) > 0;
        ArrayList<CheckStateChange<N>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<N>>(1);
        }
        ArrayList toUpdate = new ArrayList();
        this.setCheckedImpl(node, checked, toUpdate, changes);
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    @Override
    public void setChecked(@NotNull Collection<N> nodes, boolean checked) {
        boolean collectChanges = this.listeners.getListenerCount(CheckStateChangeListener.class) > 0;
        ArrayList<CheckStateChange<N>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<N>>(nodes.size());
        }
        ArrayList toUpdate = new ArrayList();
        for (MutableTreeNode node : nodes) {
            this.setCheckedImpl(node, checked, toUpdate, changes);
        }
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    protected void setCheckedImpl(@NotNull N node, boolean checked, @NotNull List<N> toUpdate, @Nullable List<CheckStateChange<N>> changes) {
        CheckState newState;
        CheckState oldState = this.getCheckState(node);
        CheckState checkState = newState = checked ? CheckState.checked : CheckState.unchecked;
        if (oldState != newState) {
            this.updateNodeState(node, newState, toUpdate);
            if (changes != null) {
                changes.add(new CheckStateChange<N>(node, oldState, newState));
            }
            if (((WebCheckBoxTree)this.checkBoxTree).isRecursiveCheckingEnabled()) {
                this.updateChildNodesState(node, newState, toUpdate, changes);
                this.updateParentStates(node, toUpdate, changes);
            }
        }
    }

    protected void updateParentStates(@NotNull N node, @NotNull List<N> toUpdate, @Nullable List<CheckStateChange<N>> changes) {
        N parent = this.getParent(node);
        while (parent != null) {
            CheckState oldState;
            CheckState state = CheckState.unchecked;
            boolean hasChecked = false;
            boolean hasUnchecked = false;
            for (int i = 0; i < this.getChildCount(parent); ++i) {
                CheckState checkState = this.getCheckState(this.getChildAt(parent, i));
                if (checkState == CheckState.mixed) {
                    state = CheckState.mixed;
                    break;
                }
                if (checkState == CheckState.checked) {
                    hasChecked = true;
                    if (hasUnchecked) {
                        state = CheckState.mixed;
                        break;
                    }
                    state = CheckState.checked;
                    continue;
                }
                if (checkState != CheckState.unchecked) continue;
                hasUnchecked = true;
                if (hasChecked) {
                    state = CheckState.mixed;
                    break;
                }
                state = CheckState.unchecked;
            }
            if ((oldState = this.getCheckState(parent)) != state) {
                if (changes != null) {
                    changes.add(new CheckStateChange<N>(parent, oldState, state));
                }
                this.updateNodeState(parent, state, toUpdate);
            }
            parent = this.getParent(parent);
        }
    }

    protected void updateChildNodesState(@NotNull N node, @NotNull CheckState newState, @NotNull List<N> toUpdate, @Nullable List<CheckStateChange<N>> changes) {
        for (int i = 0; i < this.getChildCount(node); ++i) {
            N childNode = this.getChildAt(node, i);
            if (changes != null) {
                changes.add(new CheckStateChange<N>(childNode, this.getCheckState(childNode), newState));
            }
            this.updateNodeState(childNode, newState, toUpdate);
            this.updateChildNodesState(childNode, newState, toUpdate, changes);
        }
    }

    protected void updateNodeState(@NotNull N node, @NotNull CheckState newState, @NotNull List<N> toUpdate) {
        if (newState != CheckState.unchecked) {
            this.nodeCheckStates.put(node, newState);
        } else {
            this.nodeCheckStates.remove(node);
        }
        toUpdate.add(node);
    }

    @Override
    public void invertCheck(@NotNull N node) {
        boolean collectChanges = this.listeners.getListenerCount(CheckStateChangeListener.class) > 0;
        ArrayList<CheckStateChange<N>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<N>>(1);
        }
        ArrayList toUpdate = new ArrayList();
        this.setCheckedImpl(node, this.getNextState(this.getCheckState(node)) == CheckState.checked, toUpdate, changes);
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    @Override
    public void invertCheck(@NotNull Collection<N> nodes) {
        boolean collectChanges = this.listeners.getListenerCount(CheckStateChangeListener.class) > 0;
        ArrayList<CheckStateChange<N>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<N>>(nodes.size());
        }
        ArrayList toUpdate = new ArrayList();
        boolean check = false;
        for (MutableTreeNode node : nodes) {
            if (this.getCheckState(node) == CheckState.checked) continue;
            check = true;
            break;
        }
        for (MutableTreeNode node : nodes) {
            this.setCheckedImpl(node, check, toUpdate, changes);
        }
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    @Override
    public void checkAll() {
        List allNodes = ((WebTree)this.checkBoxTree).getAvailableNodes();
        ArrayList<CheckStateChange<N>> changes = null;
        if (this.listeners.getListenerCount(CheckStateChangeListener.class) > 0) {
            changes = new ArrayList<CheckStateChange<N>>(allNodes.size());
            for (MutableTreeNode node : allNodes) {
                CheckState state = this.getCheckState(node);
                if (state == CheckState.checked) continue;
                changes.add(new CheckStateChange<MutableTreeNode>(node, state, CheckState.checked));
            }
        }
        for (MutableTreeNode node : allNodes) {
            this.nodeCheckStates.put(node, CheckState.checked);
        }
        this.repaintVisibleTreeRect();
        this.fireCheckStateChanged(changes);
    }

    @Override
    public void uncheckAll() {
        ArrayList<CheckStateChange<N>> changes = null;
        if (this.listeners.getListenerCount(CheckStateChangeListener.class) > 0) {
            changes = new ArrayList<CheckStateChange<N>>(this.nodeCheckStates.size());
            for (Map.Entry<N, CheckState> entry : this.nodeCheckStates.entrySet()) {
                CheckState state = entry.getValue();
                if (state != CheckState.mixed && state != CheckState.checked) continue;
                changes.add(new CheckStateChange<MutableTreeNode>((MutableTreeNode)entry.getKey(), state, CheckState.unchecked));
            }
        }
        this.nodeCheckStates.clear();
        this.repaintVisibleTreeRect();
        this.fireCheckStateChanged(changes);
    }

    @NotNull
    protected CheckState getNextState(@NotNull CheckState checkState) {
        CheckState nextState;
        switch (checkState) {
            case unchecked: {
                nextState = CheckState.checked;
                break;
            }
            case mixed: {
                nextState = ((WebCheckBoxTree)this.checkBoxTree).isCheckMixedOnToggle() ? CheckState.checked : CheckState.unchecked;
                break;
            }
            default: {
                nextState = CheckState.unchecked;
            }
        }
        return nextState;
    }

    @Override
    public void checkingModeChanged(boolean recursive) {
        boolean collectChanges = this.listeners.getListenerCount(CheckStateChangeListener.class) > 0;
        ArrayList<CheckStateChange<N>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<N>>();
        }
        ArrayList<MutableTreeNode> toUpdate = new ArrayList<MutableTreeNode>();
        if (recursive) {
            ArrayList<N> checked = new ArrayList<N>(this.nodeCheckStates.size());
            for (Map.Entry<N, CheckState> entry : this.nodeCheckStates.entrySet()) {
                if (entry.getValue() != CheckState.checked) continue;
                checked.add(entry.getKey());
            }
            this.filterOutChildNodes(checked);
            for (MutableTreeNode node : checked) {
                this.updateParentStates(node, toUpdate, changes);
                this.updateChildNodesState(node, CheckState.checked, toUpdate, changes);
            }
        } else {
            Iterator<Map.Entry<N, CheckState>> iterator = this.nodeCheckStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<N, CheckState> entry = iterator.next();
                if (entry.getValue() != CheckState.mixed) continue;
                MutableTreeNode node = (MutableTreeNode)entry.getKey();
                toUpdate.add(node);
                iterator.remove();
                if (changes == null) continue;
                changes.add(new CheckStateChange<MutableTreeNode>(node, CheckState.mixed, CheckState.unchecked));
            }
        }
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    protected void filterOutChildNodes(@NotNull List<N> nodes) {
        Iterator<N> checkedIterator = nodes.iterator();
        block0: while (checkedIterator.hasNext()) {
            MutableTreeNode node = (MutableTreeNode)checkedIterator.next();
            for (MutableTreeNode otherNode : nodes) {
                if (!this.isChildNode(node, otherNode)) continue;
                checkedIterator.remove();
                continue block0;
            }
        }
    }

    protected boolean isChildNode(@NotNull N node, @Nullable N parent) {
        boolean childNode = false;
        if (node != parent) {
            if (parent != null) {
                N nodeParent = this.getParent(node);
                while (nodeParent != null) {
                    if (nodeParent == parent) {
                        childNode = true;
                        break;
                    }
                    nodeParent = this.getParent(nodeParent);
                }
            } else {
                childNode = true;
            }
        }
        return childNode;
    }

    @Nullable
    protected N getParent(@NotNull N node) {
        return (N)((MutableTreeNode)node.getParent());
    }

    @NotNull
    protected N getChildAt(@NotNull N parent, int index) {
        return (N)((MutableTreeNode)parent.getChildAt(index));
    }

    protected int getChildCount(@NotNull N parent) {
        return parent.getChildCount();
    }

    protected void repaintVisibleTreeRect() {
        ((WebTree)this.checkBoxTree).repaint((Rectangle)((JComponent)this.checkBoxTree).getVisibleRect());
    }

    protected void repaintTreeNodes(@NotNull List<N> nodes) {
        ((WebTree)this.checkBoxTree).repaint(nodes);
    }

    @Override
    public void addCheckStateChangeListener(@NotNull CheckStateChangeListener listener) {
        this.listeners.add(CheckStateChangeListener.class, listener);
    }

    @Override
    public void removeCheckStateChangeListener(@NotNull CheckStateChangeListener listener) {
        this.listeners.remove(CheckStateChangeListener.class, listener);
    }

    public void fireCheckStateChanged(List<CheckStateChange<N>> stateChanges) {
        if (stateChanges != null) {
            for (CheckStateChangeListener listener : (CheckStateChangeListener[])this.listeners.getListeners(CheckStateChangeListener.class)) {
                listener.checkStateChanged(this.checkBoxTree, stateChanges);
            }
        }
    }
}

