/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.laf.tree.TreeUtils;
import java.util.Comparator;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class NodesPositionComparator<N extends MutableTreeNode>
implements Comparator<N> {
    @Override
    public int compare(@NotNull N n1, @NotNull N n2) {
        int result;
        if (n1 == n2) {
            result = 0;
        } else if (TreeUtils.isNodeAncestor(n1, n2)) {
            result = 1;
        } else if (TreeUtils.isNodeAncestor(n2, n1)) {
            result = -1;
        } else {
            Object p1 = n1;
            Object p2 = n2;
            while (p1 != null && p2 != null && (TreeUtils.getLevel(p1) != TreeUtils.getLevel(p2) || p1.getParent() != p2.getParent())) {
                int l2;
                int l1 = TreeUtils.getLevel(p1);
                if (l1 >= (l2 = TreeUtils.getLevel(p2))) {
                    p1 = (MutableTreeNode)p1.getParent();
                }
                if (l2 < l1) continue;
                p2 = (MutableTreeNode)p2.getParent();
            }
            if (p1 != null && p2 != null) {
                MutableTreeNode parent = (MutableTreeNode)p1.getParent();
                result = new Integer(parent.getIndex((TreeNode)p1)).compareTo(parent.getIndex((TreeNode)p2));
            } else {
                result = 0;
            }
        }
        return result;
    }
}

