/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Function;
import com.alee.extended.tree.NodesFilter;
import com.alee.extended.tree.UniqueNodeTextProvider;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeNode;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class StructuredTreeNodesFilter<N extends UniqueNode>
implements NodesFilter<N> {
    @NotNull
    protected final Map<String, Boolean> acceptStatesCache = new HashMap<String, Boolean>();
    @NotNull
    protected Function<N, String> textProvider;
    protected boolean matchCase;
    protected boolean useSpaceAsSeparator;
    protected boolean searchFromStart;
    @NotNull
    protected String searchText;

    public StructuredTreeNodesFilter() {
        this(new UniqueNodeTextProvider());
    }

    public StructuredTreeNodesFilter(@NotNull Function<N, String> textProvider) {
        this.textProvider = textProvider;
        this.matchCase = false;
        this.useSpaceAsSeparator = false;
        this.searchFromStart = false;
        this.searchText = "";
    }

    @NotNull
    public Function<N, String> getTextProvider() {
        return this.textProvider;
    }

    public void setTextProvider(@NotNull Function<N, String> textProvider) {
        this.textProvider = textProvider;
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public void setMatchCase(boolean matchCase) {
        this.matchCase = matchCase;
    }

    public boolean isUseSpaceAsSeparator() {
        return this.useSpaceAsSeparator;
    }

    public void setUseSpaceAsSeparator(boolean useSpaceAsSeparator) {
        this.useSpaceAsSeparator = useSpaceAsSeparator;
    }

    public boolean isSearchFromStart() {
        return this.searchFromStart;
    }

    public void setSearchFromStart(boolean searchFromStart) {
        this.searchFromStart = searchFromStart;
    }

    @NotNull
    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(@Nullable String searchText) {
        this.searchText = searchText != null ? searchText : "";
    }

    @Override
    public void clearCache() {
        this.acceptStatesCache.clear();
    }

    @Override
    public void clearCache(@NotNull N node) {
        this.acceptStatesCache.remove(((UniqueNode)node).getId());
    }

    public boolean accept(@NotNull N node) {
        String searchRequest = this.matchCase ? this.searchText : this.searchText.toLowerCase(Locale.ROOT);
        return searchRequest.equals("") || this.acceptIncludingChildren(node, searchRequest);
    }

    protected boolean acceptIncludingChildren(@NotNull N node, @NotNull String searchRequest) {
        boolean accepted;
        if (this.acceptNode(node, searchRequest)) {
            accepted = true;
        } else {
            accepted = false;
            for (int i = 0; i < ((WebTreeNode)node).getChildCount(); ++i) {
                if (!this.acceptIncludingChildren((UniqueNode)((WebTreeNode)node).getChildAt(i), searchRequest)) continue;
                accepted = true;
                break;
            }
        }
        return accepted;
    }

    protected boolean acceptNode(@NotNull N node, @NotNull String searchRequest) {
        Boolean accept = this.acceptStatesCache.get(((UniqueNode)node).getId());
        if (accept == null) {
            accept = this.acceptNodeImpl(node, searchRequest);
            this.acceptStatesCache.put(((UniqueNode)node).getId(), accept);
        }
        return accept;
    }

    protected boolean acceptNodeImpl(@NotNull N node, @NotNull String searchRequest) {
        boolean accepted;
        String nodeText;
        String rawText = (String)this.textProvider.apply(node);
        String string = nodeText = this.matchCase ? rawText : rawText.toLowerCase(Locale.ROOT);
        if (this.useSpaceAsSeparator) {
            accepted = false;
            StringTokenizer tokenizer = new StringTokenizer(searchRequest, " ", false);
            while (tokenizer.hasMoreTokens()) {
                if (!this.accept(nodeText, tokenizer.nextToken(), this.searchFromStart)) continue;
                accepted = true;
                break;
            }
        } else {
            accepted = this.accept(nodeText, searchRequest, this.searchFromStart);
        }
        return accepted;
    }

    protected boolean accept(String nodeText, String searchRequest, boolean searchFromStart) {
        return searchFromStart ? nodeText.startsWith(searchRequest) : nodeText.contains(searchRequest);
    }
}

