/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.AsyncPathExpansionListener;
import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeListener;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.AsyncTreeModelListener;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.FilterableNodes;
import com.alee.extended.tree.SortableNodes;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeNode;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.Filter;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebAsyncTree<N extends AsyncUniqueNode>
extends WebTree<N>
implements FilterableNodes<N>,
SortableNodes<N>,
AsyncTreeModelListener<N> {
    public static final String DATA_PROVIDER_PROPERTY = "dataProvider";
    public static final String FILTER_PROPERTY = "filter";
    public static final String COMPARATOR_PROPERTY = "comparator";
    public static final String ASYNC_LOADING_PROPERTY = "asyncLoading";
    @Nullable
    protected Boolean asyncLoading;
    @Nullable
    protected Filter<N> filter;
    @Nullable
    protected Comparator<N> comparator;

    public WebAsyncTree() {
        this(StyleId.auto);
    }

    public WebAsyncTree(@Nullable AsyncTreeDataProvider dataProvider) {
        this(StyleId.auto, dataProvider);
    }

    public WebAsyncTree(@Nullable AsyncTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer) {
        this(StyleId.auto, dataProvider, renderer);
    }

    public WebAsyncTree(@Nullable AsyncTreeDataProvider dataProvider, @Nullable TreeCellEditor editor) {
        this(StyleId.auto, dataProvider, editor);
    }

    public WebAsyncTree(@Nullable AsyncTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer, @Nullable TreeCellEditor editor) {
        this(StyleId.auto, dataProvider, renderer, editor);
    }

    public WebAsyncTree(@NotNull StyleId id) {
        this(id, null, null, null);
    }

    public WebAsyncTree(@NotNull StyleId id, @Nullable AsyncTreeDataProvider dataProvider) {
        this(id, dataProvider, null, null);
    }

    public WebAsyncTree(@NotNull StyleId id, @Nullable AsyncTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer) {
        this(id, dataProvider, renderer, null);
    }

    public WebAsyncTree(@NotNull StyleId id, @Nullable AsyncTreeDataProvider dataProvider, @Nullable TreeCellEditor editor) {
        this(id, dataProvider, null, editor);
    }

    public WebAsyncTree(@NotNull StyleId id, @Nullable AsyncTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer, @Nullable TreeCellEditor editor) {
        super(id, dataProvider != null ? new AsyncTreeModel(dataProvider) : null);
        if (renderer != null) {
            this.setCellRenderer(renderer);
        }
        if (editor != null) {
            this.setEditable(true);
            this.setCellEditor(editor);
        }
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.asynctree;
    }

    @Override
    @Nullable
    public AsyncTreeModel<N> getModel() {
        return (AsyncTreeModel)super.getModel();
    }

    @Override
    public void setModel(@Nullable TreeModel newModel) {
        WebLookAndFeel.checkEventDispatchThread();
        if (newModel instanceof AsyncTreeModel) {
            AsyncTreeDataProvider oldDataProvider;
            TreeModel old = this.getModel();
            if (old != null) {
                oldDataProvider = ((AsyncTreeModel)old).getDataProvider();
                ((AsyncTreeModel)old).uninstall(this);
            } else {
                oldDataProvider = null;
            }
            AsyncTreeModel model = (AsyncTreeModel)newModel;
            model.install(this);
            super.setModel(model);
            this.firePropertyChange(DATA_PROVIDER_PROPERTY, oldDataProvider, model.getDataProvider());
        } else if (newModel != null) {
            throw new NullPointerException("Only AsyncTreeModel implementations can be used for WebAsyncTree");
        }
    }

    @Nullable
    public AsyncTreeDataProvider<N> getDataProvider() {
        TreeModel model = this.getModel();
        return model != null ? ((AsyncTreeModel)model).getDataProvider() : null;
    }

    public void setDataProvider(@NotNull AsyncTreeDataProvider dataProvider) {
        WebLookAndFeel.checkEventDispatchThread();
        this.setModel(new AsyncTreeModel(dataProvider));
    }

    public boolean isAsyncLoading() {
        return this.asyncLoading == null || this.asyncLoading != false;
    }

    public void setAsyncLoading(boolean asyncLoading) {
        WebLookAndFeel.checkEventDispatchThread();
        if (asyncLoading != this.isAsyncLoading()) {
            boolean old = this.isAsyncLoading();
            this.asyncLoading = asyncLoading;
            this.firePropertyChange(ASYNC_LOADING_PROPERTY, old, asyncLoading);
        }
    }

    @Override
    @Nullable
    public Filter<N> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(@Nullable Filter<N> filter) {
        WebLookAndFeel.checkEventDispatchThread();
        if (filter != this.getFilter()) {
            Filter<N> old = this.getFilter();
            this.filter = filter;
            this.filter();
            this.firePropertyChange(FILTER_PROPERTY, old, filter);
        }
    }

    @Override
    public void clearFilter() {
        this.setFilter(null);
    }

    @Override
    public void filter() {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).filter();
        }
    }

    @Override
    public void filter(@NotNull N parent) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).filter(parent);
        }
    }

    @Override
    public void filter(@NotNull N parent, boolean recursively) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).filter(parent, recursively);
        }
    }

    @Override
    @Nullable
    public Comparator<N> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(@Nullable Comparator<N> comparator) {
        WebLookAndFeel.checkEventDispatchThread();
        if (comparator != this.getComparator()) {
            Comparator<N> old = this.getComparator();
            this.comparator = comparator;
            this.sort();
            this.firePropertyChange(COMPARATOR_PROPERTY, old, comparator);
        }
    }

    @Override
    public void clearComparator() {
        this.setComparator(null);
    }

    @Override
    public void sort() {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).sort();
        }
    }

    @Override
    public void sort(@NotNull N parent) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).sort(parent);
        }
    }

    @Override
    public void sort(@NotNull N parent, boolean recursively) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).sort(parent, recursively);
        }
    }

    public void filterAndSort() {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).filterAndSort(true);
        }
    }

    public void filterAndSort(@NotNull N parent) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).filterAndSort(parent, false);
        }
    }

    public void filterAndSort(@NotNull N parent, boolean recursively) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).filterAndSort(parent, recursively);
        }
    }

    public void setChildNodes(@NotNull N parent, @NotNull List<N> children) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).setChildNodes(parent, children);
        }
    }

    public void addChildNode(@NotNull N parent, @NotNull N child) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).addChildNode(parent, child);
        }
    }

    public void addChildNodes(@NotNull N parent, @NotNull List<N> children) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).addChildNodes(parent, children);
        }
    }

    public void insertChildNodes(@NotNull List<N> children, @NotNull N parent, int index) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).insertNodesInto(children, parent, index);
        }
    }

    public void insertChildNodes(@NotNull N[] children, @NotNull N parent, int index) {
        TreeModel model = this.getModel();
        if (model != null) {
            model.insertNodesInto((AsyncUniqueNode[])children, (AsyncUniqueNode)parent, index);
        }
    }

    public void insertChildNode(@NotNull N child, @NotNull N parent, int index) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
        }
    }

    public void removeNode(@NotNull String nodeId) {
        N node = this.findNode(nodeId);
        if (node != null) {
            this.removeNode(node);
        }
    }

    public void removeNode(@NotNull N node) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public void removeNodes(@NotNull List<N> nodes) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).removeNodesFromParent(nodes);
        }
    }

    public void removeNodes(@NotNull N[] nodes) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((AsyncTreeModel)model).removeNodesFromParent(nodes);
        }
    }

    public boolean areChildrenLoaded(@NotNull N parent) {
        TreeModel model = this.getModel();
        return model != null && ((AsyncTreeModel)model).areChildrenLoaded(parent);
    }

    @Nullable
    public N findNode(@NotNull String nodeId) {
        TreeModel model = this.getModel();
        return model != null ? (N)((AsyncTreeModel)model).findNode(nodeId) : null;
    }

    @Override
    public void updateNode(@NotNull String nodeId) {
        this.updateNode(this.findNode(nodeId));
    }

    public void updateNodeStructure(@NotNull String nodeId) {
        this.updateNodeStructure(this.findNode(nodeId));
    }

    public void updateNodeStructure(@Nullable N node) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((WebTreeModel)model).updateNodeStructure(node);
        }
    }

    public void reloadSelectedNodesSync() {
        boolean async = this.isAsyncLoading();
        this.setAsyncLoading(false);
        this.reloadSelectedNodes();
        this.setAsyncLoading(async);
    }

    public void reloadSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                AsyncUniqueNode node = (AsyncUniqueNode)this.getNodeForPath(path);
                if (node == null || node.isLoading()) continue;
                this.performReload(node, path, false);
            }
        }
    }

    @Nullable
    public N reloadNodeUnderPoint(@NotNull Point point) {
        return this.reloadNodeUnderPoint(point.x, point.y);
    }

    @Nullable
    public N reloadNodeUnderPoint(int x, int y) {
        return this.reloadPath(this.getPathForLocation(x, y));
    }

    @Nullable
    public N reloadNodeSync(@NotNull String nodeId) {
        return this.reloadNodeSync(this.findNode(nodeId));
    }

    @Nullable
    public N reloadNodeSync(@Nullable N node) {
        return this.reloadNodeSync(node, false);
    }

    @Nullable
    public N reloadNodeSync(@Nullable N node, boolean select) {
        boolean async = this.isAsyncLoading();
        this.setAsyncLoading(false);
        N reloadedNode = this.reloadNode(node, select);
        this.setAsyncLoading(async);
        return reloadedNode;
    }

    @Nullable
    public N reloadRootNode() {
        return (N)this.reloadNode((AsyncUniqueNode)this.getRootNode());
    }

    @Nullable
    public N reloadNode(@NotNull String nodeId) {
        return this.reloadNode(this.findNode(nodeId));
    }

    @Nullable
    public N reloadNode(@Nullable N node) {
        return this.reloadNode(node, false);
    }

    @Nullable
    public N reloadNode(@Nullable N node, boolean select) {
        TreePath path;
        N reloadedNode = null;
        if (node != null && !((AsyncUniqueNode)node).isLoading() && (path = this.getPathForNode(node)) != null) {
            this.performReload(node, path, select);
            reloadedNode = node;
        }
        return reloadedNode;
    }

    @Nullable
    public N reloadPathSync(@Nullable TreePath path) {
        return this.reloadPathSync(path, false);
    }

    @Nullable
    public N reloadPathSync(@Nullable TreePath path, boolean select) {
        boolean async = this.isAsyncLoading();
        this.setAsyncLoading(false);
        N reloadedNode = this.reloadPath(path, select);
        this.setAsyncLoading(async);
        return reloadedNode;
    }

    @Nullable
    public N reloadPath(@Nullable TreePath path) {
        return this.reloadPath(path, false);
    }

    @Nullable
    public N reloadPath(@Nullable TreePath path, boolean select) {
        AsyncUniqueNode node;
        AsyncUniqueNode reloadedNode = null;
        if (path != null && (node = (AsyncUniqueNode)this.getNodeForPath(path)) != null && !node.isLoading()) {
            this.performReload(node, path, select);
            reloadedNode = node;
        }
        return (N)reloadedNode;
    }

    protected void performReload(@NotNull N node, @NotNull TreePath path, boolean select) {
        TreeModel model;
        if (select && !this.isPathSelected(path)) {
            this.setSelectionPath(path);
        }
        if (!this.isExpanded(path)) {
            this.expandPath(path);
        }
        if (!((AsyncUniqueNode)node).isLoading() && (model = this.getModel()) != null) {
            ((AsyncTreeModel)model).reload((TreeNode)node);
        }
    }

    @Override
    public void expandNode(@NotNull String nodeId) {
        this.expandNode(this.findNode(nodeId));
    }

    public void expandPath(@NotNull List<String> pathNodeIds) {
        this.expandPath(pathNodeIds, true, true, null);
    }

    public void expandPath(@NotNull List<String> pathNodeIds, @Nullable AsyncPathExpansionListener<N> listener) {
        this.expandPath(pathNodeIds, true, true, listener);
    }

    public void expandPath(@NotNull List<String> pathNodeIds, boolean expandLastNode) {
        this.expandPath(pathNodeIds, expandLastNode, true, null);
    }

    public void expandPath(@NotNull List<String> pathNodeIds, boolean expandLastNode, @Nullable AsyncPathExpansionListener<N> listener) {
        this.expandPath(pathNodeIds, expandLastNode, true, listener);
    }

    public void expandPath(@NotNull List<String> pathNodeIds, boolean expandLastNode, boolean selectLastNode) {
        this.expandPath(pathNodeIds, expandLastNode, selectLastNode, null);
    }

    public void expandPath(@NotNull List<String> pathNodeIds, boolean expandLastNode, boolean selectLastNode, @Nullable AsyncPathExpansionListener<N> listener) {
        boolean expanded = false;
        ArrayList ids = CollectionUtils.copy(pathNodeIds);
        for (int initial = 0; initial < ids.size(); ++initial) {
            N initialNode = this.findNode((String)ids.get(initial));
            if (initialNode == null) continue;
            for (int i = initial; i >= 0; --i) {
                ids.remove(i);
            }
            if (ids.size() > 0) {
                this.expandPathImpl(initialNode, ids, expandLastNode, selectLastNode, listener);
            }
            expanded = true;
            break;
        }
        if (!expanded && listener != null) {
            listener.pathFailedToExpand();
        }
    }

    protected void expandPathImpl(@NotNull N currentNode, @NotNull List<String> leftToExpand, boolean expandLastNode, boolean selectLastNode, @Nullable AsyncPathExpansionListener<N> listener) {
        if (leftToExpand.size() > 0) {
            if (((AsyncUniqueNode)currentNode).isLoaded()) {
                this.expandNode(currentNode);
                if (listener != null) {
                    listener.pathNodeExpanded(currentNode);
                }
                N nextNode = this.findNode(leftToExpand.get(0));
                leftToExpand.remove(0);
                if (nextNode != null) {
                    this.expandPathImpl(nextNode, leftToExpand, expandLastNode, selectLastNode, listener);
                } else {
                    this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
                    if (listener != null) {
                        listener.pathPartiallyExpanded(currentNode);
                    }
                }
            } else {
                this.addAsyncTreeListener(new AsyncTreeAdapter((AsyncUniqueNode)currentNode, listener, leftToExpand, expandLastNode, selectLastNode){
                    final /* synthetic */ AsyncUniqueNode val$currentNode;
                    final /* synthetic */ AsyncPathExpansionListener val$listener;
                    final /* synthetic */ List val$leftToExpand;
                    final /* synthetic */ boolean val$expandLastNode;
                    final /* synthetic */ boolean val$selectLastNode;
                    {
                        this.val$currentNode = asyncUniqueNode;
                        this.val$listener = asyncPathExpansionListener;
                        this.val$leftToExpand = list;
                        this.val$expandLastNode = bl;
                        this.val$selectLastNode = bl2;
                    }

                    @Override
                    public void loadCompleted(@NotNull AsyncUniqueNode parent, @NotNull List children) {
                        if (parent.getId().equals(this.val$currentNode.getId())) {
                            WebAsyncTree.this.removeAsyncTreeListener(this);
                            if (this.val$listener != null) {
                                this.val$listener.pathNodeExpanded(this.val$currentNode);
                            }
                            Object nextNode = WebAsyncTree.this.findNode((String)this.val$leftToExpand.get(0));
                            this.val$leftToExpand.remove(0);
                            if (nextNode != null) {
                                WebAsyncTree.this.expandPathImpl(nextNode, this.val$leftToExpand, this.val$expandLastNode, this.val$selectLastNode, this.val$listener);
                            } else {
                                WebAsyncTree.this.expandPathEndImpl(this.val$currentNode, this.val$expandLastNode, this.val$selectLastNode);
                                if (this.val$listener != null) {
                                    this.val$listener.pathPartiallyExpanded(this.val$currentNode);
                                }
                            }
                        }
                    }

                    @Override
                    public void loadFailed(@NotNull AsyncUniqueNode parent, @NotNull Throwable cause) {
                        if (parent.getId().equals(this.val$currentNode.getId())) {
                            WebAsyncTree.this.removeAsyncTreeListener(this);
                            WebAsyncTree.this.expandPathEndImpl(this.val$currentNode, this.val$expandLastNode, this.val$selectLastNode);
                            if (this.val$listener != null) {
                                this.val$listener.pathPartiallyExpanded(this.val$currentNode);
                            }
                        }
                    }
                });
                this.expandNode(currentNode);
            }
        } else {
            this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
            if (listener != null) {
                listener.pathExpanded(currentNode);
            }
        }
    }

    protected void expandPathEndImpl(@Nullable N lastFoundNode, boolean expandLastNode, boolean selectLastNode) {
        if (selectLastNode) {
            this.setSelectedNode(lastFoundNode);
            this.scrollToNode(lastFoundNode);
        }
        if (expandLastNode) {
            this.expandNode(lastFoundNode);
        }
    }

    @Override
    protected void expandAllImpl(@NotNull N node, @Nullable Filter<N> filter, int depth) {
        TreeModel model = this.getModel();
        if (model != null) {
            if (this.isAsyncLoading()) {
                if (depth > 0 && (filter == null || filter.accept(node)) && !((AsyncTreeModel)model).isLeaf(node)) {
                    if (this.hasBeenExpanded(this.getPathForNode(node))) {
                        if (!this.isExpanded(node)) {
                            this.expandNode(node);
                        }
                        for (int i = 0; i < ((WebTreeNode)node).getChildCount(); ++i) {
                            this.expandAllImpl((N)((AsyncUniqueNode)((WebTreeNode)node).getChildAt(i)), filter, depth - 1);
                        }
                    } else if (!this.isExpanded(node)) {
                        this.addAsyncTreeListener(new AsyncTreeAdapter<N>((AsyncUniqueNode)node, (Filter)filter, depth){
                            final /* synthetic */ AsyncUniqueNode val$node;
                            final /* synthetic */ Filter val$filter;
                            final /* synthetic */ int val$depth;
                            {
                                this.val$node = asyncUniqueNode;
                                this.val$filter = filter;
                                this.val$depth = n;
                            }

                            @Override
                            public void loadCompleted(@NotNull N parent, @NotNull List<N> children) {
                                if (parent == this.val$node) {
                                    for (AsyncUniqueNode child : children) {
                                        WebAsyncTree.this.expandAllImpl(child, this.val$filter, this.val$depth - 1);
                                    }
                                    WebAsyncTree.this.removeAsyncTreeListener(this);
                                }
                            }

                            @Override
                            public void loadFailed(@NotNull N parent, @NotNull Throwable cause) {
                                if (parent == this.val$node) {
                                    WebAsyncTree.this.removeAsyncTreeListener(this);
                                }
                            }
                        });
                        this.expandNode(node);
                    }
                }
            } else {
                super.expandAllImpl(node, filter, depth);
            }
        }
    }

    public List<AsyncTreeListener> getAsyncTreeListeners() {
        return CollectionUtils.asList((Object[])this.listenerList.getListeners(AsyncTreeListener.class));
    }

    public void addAsyncTreeListener(AsyncTreeListener listener) {
        this.listenerList.add(AsyncTreeListener.class, listener);
    }

    public void removeAsyncTreeListener(AsyncTreeListener listener) {
        this.listenerList.remove(AsyncTreeListener.class, listener);
    }

    @Override
    public void loadStarted(@NotNull N parent) {
        this.fireChildrenLoadStarted(parent);
    }

    protected void fireChildrenLoadStarted(N parent) {
        for (AsyncTreeListener listener : (AsyncTreeListener[])this.listenerList.getListeners(AsyncTreeListener.class)) {
            listener.loadStarted(parent);
        }
    }

    @Override
    public void loadCompleted(@NotNull N parent, @NotNull List<N> children) {
        this.fireChildrenLoadCompleted(parent, children);
    }

    protected void fireChildrenLoadCompleted(N parent, List<N> children) {
        for (AsyncTreeListener listener : (AsyncTreeListener[])this.listenerList.getListeners(AsyncTreeListener.class)) {
            listener.loadCompleted(parent, children);
        }
    }

    @Override
    public void loadFailed(@NotNull N parent, @NotNull Throwable cause) {
        this.fireChildrenLoadFailed(parent, cause);
    }

    protected void fireChildrenLoadFailed(N parent, Throwable cause) {
        for (AsyncTreeListener listener : (AsyncTreeListener[])this.listenerList.getListeners(AsyncTreeListener.class)) {
            listener.loadFailed(parent, cause);
        }
    }
}

