/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Function;
import com.alee.extended.tree.FilterableNodes;
import com.alee.extended.tree.StructuredTreeNodesFilter;
import com.alee.extended.tree.UniqueNodeTextProvider;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.menu.WebCheckBoxMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.text.WebTextField;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeNode;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.utils.swing.extensions.DocumentEventRunnable;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class WebTreeFilterField<N extends UniqueNode>
extends WebTextField {
    protected JTree tree;
    protected TreeModel model;
    protected StructuredTreeNodesFilter<N> filter;
    protected PropertyChangeListener treeModelChangeListener;
    protected boolean defaultTreeStateBehavior;
    protected WebButton filterIcon;
    protected WebPopupMenu settingsMenu;
    protected WebCheckBoxMenuItem matchCaseItem;
    protected WebCheckBoxMenuItem useSpaceAsSeparatorItem;
    protected WebCheckBoxMenuItem searchFromStartItem;
    @Nullable
    protected transient TreeState treeState;
    @Nullable
    protected transient Rectangle visibleRect;

    public WebTreeFilterField(@NotNull JTree tree) {
        this(StyleId.auto, tree);
    }

    public WebTreeFilterField(@NotNull JTree tree, @NotNull Function<N, String> textProvider) {
        this(StyleId.auto, tree, textProvider);
    }

    public WebTreeFilterField(@NotNull StyleId id, @NotNull JTree tree) {
        this(id, tree, new UniqueNodeTextProvider());
    }

    public WebTreeFilterField(@NotNull StyleId id, @NotNull JTree tree, @NotNull Function<N, String> textProvider) {
        super(id);
        this.setLanguage("weblaf.ex.treefilter.inputprompt", new Object[0]);
        this.initDefaultFilter();
        this.initFilterIcon();
        this.initSettingsMenu();
        this.initListeners();
        this.setDefaultTreeStateBehavior(true);
        this.setTextProvider(textProvider);
        this.setTree(tree);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.treefilterfield;
    }

    protected void initDefaultFilter() {
        this.filter = new StructuredTreeNodesFilter();
    }

    protected void initFilterIcon() {
        this.filterIcon = new WebButton(StyleId.treefilterfieldSettings.at(this), (Icon)Icons.filter, (Icon)Icons.filterHover);
        this.filterIcon.setCursor(Cursor.getDefaultCursor());
        this.filterIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebTreeFilterField.this.settingsMenu.showBelowStart(WebTreeFilterField.this.filterIcon);
            }
        });
        this.setLeadingComponent(this.filterIcon);
    }

    protected void initSettingsMenu() {
        this.settingsMenu = new WebPopupMenu();
        this.matchCaseItem = new WebCheckBoxMenuItem();
        this.matchCaseItem.setLanguage("weblaf.filter.matchcase", new Object[0]);
        this.matchCaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebTreeFilterField.this.filter.setMatchCase(WebTreeFilterField.this.matchCaseItem.isSelected());
                WebTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.matchCaseItem);
        this.useSpaceAsSeparatorItem = new WebCheckBoxMenuItem();
        this.useSpaceAsSeparatorItem.setLanguage("weblaf.filter.spaceseparator", new Object[0]);
        this.useSpaceAsSeparatorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebTreeFilterField.this.filter.setUseSpaceAsSeparator(WebTreeFilterField.this.useSpaceAsSeparatorItem.isSelected());
                WebTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.useSpaceAsSeparatorItem);
        this.searchFromStartItem = new WebCheckBoxMenuItem();
        this.searchFromStartItem.setLanguage("weblaf.filter.frombeginning", new Object[0]);
        this.searchFromStartItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebTreeFilterField.this.filter.setSearchFromStart(WebTreeFilterField.this.searchFromStartItem.isSelected());
                WebTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.searchFromStartItem);
    }

    protected void initListeners() {
        this.onChange(new DocumentEventRunnable<WebTextField>(){

            @Override
            public void run(@NotNull WebTextField component, @Nullable DocumentEvent event) {
                WebTreeFilterField.this.filter.setSearchText(component.getText());
                WebTreeFilterField.this.updateFiltering();
            }
        });
        this.onKeyPress(Hotkey.ESCAPE, new KeyEventRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                WebTreeFilterField.this.clear();
            }
        });
        this.treeModelChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                TreeModel newModel = (TreeModel)evt.getNewValue();
                WebTreeFilterField.this.checkTreeModel(newModel);
                WebTreeFilterField.this.removeFieldFilter();
                WebTreeFilterField.this.clearState();
                WebTreeFilterField.this.model = newModel;
                WebTreeFilterField.this.saveState();
                WebTreeFilterField.this.applyFieldFilter();
            }
        };
    }

    @NotNull
    public JTree getTree() {
        return this.tree;
    }

    public void setTree(@NotNull JTree tree) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkTreeModel(tree.getModel());
        this.removeFieldFilter();
        this.restoreState();
        this.tree = tree;
        this.model = tree.getModel();
        this.saveState();
        this.applyFieldFilter();
    }

    protected void checkTreeModel(@Nullable TreeModel model) {
        if (!(model instanceof FilterableNodes)) {
            throw new RuntimeException("WebTreeFilterField only supports tree models that implement FilterableNodes");
        }
    }

    @NotNull
    public FilterableNodes<N> getFilterableModel() {
        return (FilterableNodes)((Object)this.model);
    }

    @NotNull
    public StructuredTreeNodesFilter<N> getFilter() {
        return this.filter;
    }

    public void setFilter(@NotNull StructuredTreeNodesFilter<N> filter) {
        WebLookAndFeel.checkEventDispatchThread();
        this.saveState();
        this.removeFieldFilter();
        this.filter = filter;
        this.applyFieldFilter();
        this.restoreState();
    }

    protected void applyFieldFilter() {
        if (this.tree != null) {
            this.getFilterableModel().setFilter(this.filter);
            this.tree.addPropertyChangeListener("model", this.treeModelChangeListener);
        }
    }

    protected void removeFieldFilter() {
        if (this.tree != null) {
            this.tree.removePropertyChangeListener("model", this.treeModelChangeListener);
            this.getFilterableModel().clearFilter();
            this.filter.clearCache();
        }
    }

    @NotNull
    public Function<N, String> getTextProvider() {
        return this.filter.getTextProvider();
    }

    public void setTextProvider(@NotNull Function<N, String> textProvider) {
        WebLookAndFeel.checkEventDispatchThread();
        this.filter.setTextProvider(textProvider);
        this.updateFiltering();
    }

    public boolean isDefaultTreeStateBehavior() {
        return this.defaultTreeStateBehavior;
    }

    public void setDefaultTreeStateBehavior(boolean defaultTreeStateBehavior) {
        this.defaultTreeStateBehavior = defaultTreeStateBehavior;
    }

    public void updateFiltering() {
        WebLookAndFeel.checkEventDispatchThread();
        if (this.tree != null) {
            this.saveState();
            this.filter.clearCache();
            this.getFilterableModel().filter();
            if (!this.isEmpty()) {
                this.expandToFilteredNodes();
            } else {
                this.restoreState();
            }
        }
    }

    protected void saveState() {
        if (this.tree != null && this.defaultTreeStateBehavior && !this.isEmpty() && this.treeState == null) {
            this.treeState = TreeUtils.getTreeState(this.tree);
            this.visibleRect = this.tree.getVisibleRect();
        }
    }

    protected void restoreState() {
        if (this.tree != null && this.defaultTreeStateBehavior && this.treeState != null) {
            TreeUtils.setTreeState(this.tree, this.treeState);
            this.tree.scrollRectToVisible(this.visibleRect);
            this.treeState = null;
            this.visibleRect = null;
        }
    }

    protected void clearState() {
        if (this.tree != null && this.defaultTreeStateBehavior && this.treeState != null) {
            this.treeState = null;
            this.visibleRect = null;
        }
    }

    protected void expandToFilteredNodes() {
        if (this.tree != null && this.defaultTreeStateBehavior) {
            TreeUtils.expandLoaded(this.tree);
        }
    }

    public void clearNodeCache(@NotNull N node) {
        WebLookAndFeel.checkEventDispatchThread();
        if (this.tree != null) {
            this.filter.clearCache(node);
            TreeNode parent = ((WebTreeNode)node).getParent();
            if (parent != null) {
                this.getFilterableModel().filter((UniqueNode)parent);
            }
        }
    }
}

