/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.extended.behavior.Behavior;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class WindowFollowBehavior
extends ComponentAdapter
implements Behavior {
    protected final Window attached;
    protected final Window followed;
    protected boolean enabled;
    protected Point lastLocation;

    public WindowFollowBehavior(Window attached, Window followed) {
        this.attached = attached;
        this.followed = followed;
        this.enabled = true;
        this.updateLastLocation();
    }

    public void install() {
        this.followed.addComponentListener(this);
    }

    public void uninstall() {
        this.followed.removeComponentListener(this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Window getAttached() {
        return this.attached;
    }

    public Window getFollowed() {
        return this.followed;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateLastLocation();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.isEnabled() && this.attached != null && this.followed != null) {
            Point nl = this.followed.getLocation();
            Point fwl = this.attached.getLocation();
            this.attached.setLocation(fwl.x + nl.x - this.lastLocation.x, fwl.y + nl.y - this.lastLocation.y);
            this.lastLocation = nl;
        }
    }

    public void updateLastLocation() {
        this.lastLocation = this.followed.getLocation();
    }
}

