/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.painter.SpecificPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractButtonModelPainter<C extends JComponent, U extends ComponentUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements SpecificPainter<C, U> {
    protected transient ChangeListener buttonModelChangeListener;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installModelChangeListener();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallModelChangeListener();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"model")) {
            if (oldValue != null && this.buttonModelChangeListener != null) {
                ((ButtonModel)oldValue).removeChangeListener(this.buttonModelChangeListener);
            }
            if (newValue != null && this.buttonModelChangeListener != null) {
                ((ButtonModel)newValue).addChangeListener(this.buttonModelChangeListener);
            }
            this.updateDecorationState();
        }
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (this.isPressed()) {
            states.add("pressed");
        }
        states.add(this.isSelected() ? "selected" : "unselected");
        return states;
    }

    protected void installModelChangeListener() {
        this.buttonModelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (AbstractButtonModelPainter.this.component != null) {
                    AbstractButtonModelPainter.this.updateDecorationState();
                }
            }
        };
        this.getButtonModel().addChangeListener(this.buttonModelChangeListener);
    }

    protected void uninstallModelChangeListener() {
        this.getButtonModel().removeChangeListener(this.buttonModelChangeListener);
        this.buttonModelChangeListener = null;
    }

    protected boolean isPressed() {
        return this.getButtonModel().isPressed();
    }

    protected boolean isSelected() {
        return this.getButtonModel().isSelected();
    }

    @NotNull
    protected abstract ButtonModel getButtonModel();
}

