/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIAction;
import com.alee.laf.UIActionMap;
import com.alee.laf.button.ButtonInputListener;
import com.alee.laf.button.WButtonUI;
import com.alee.utils.LafLookup;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentInputMapUIResource;

public class WButtonInputListener<C extends AbstractButton, U extends WButtonUI<C>>
extends AbstractUIInputListener<C, U>
implements ButtonInputListener<C>,
MouseListener,
MouseMotionListener,
FocusListener,
AncestorListener,
PropertyChangeListener {
    protected long lastPressedTimestamp = -1L;
    protected boolean shouldDiscardRelease = false;

    @Override
    public void install(@NotNull C component) {
        super.install(component);
        ((Component)component).addMouseListener(this);
        ((Component)component).addMouseMotionListener(this);
        ((Component)component).addFocusListener(this);
        ((JComponent)component).addAncestorListener(this);
        ((Container)component).addPropertyChangeListener(this);
        UIActionMap actionMap = new UIActionMap();
        actionMap.put(new Action<C>(component, "pressed"));
        actionMap.put(new Action<C>(component, "released"));
        SwingUtilities.replaceUIActionMap(component, actionMap);
        InputMap inputMap = LafLookup.getInputMap(component, 0);
        SwingUtilities.replaceUIInputMap(component, 0, inputMap);
        this.updateMnemonicBinding((AbstractButton)component);
    }

    @Override
    public void uninstall(@NotNull C component) {
        SwingUtilities.replaceUIInputMap(component, 2, null);
        SwingUtilities.replaceUIInputMap(component, 0, null);
        SwingUtilities.replaceUIActionMap(component, null);
        ((Component)component).removePropertyChangeListener(this);
        ((JComponent)component).removeAncestorListener(this);
        ((Component)component).removeFocusListener(this);
        ((Component)component).removeMouseMotionListener(this);
        ((Component)component).removeMouseListener(this);
        super.uninstall(component);
    }

    protected void updateMnemonicBinding(@NotNull AbstractButton button) {
        int m = button.getMnemonic();
        if (m != 0) {
            InputMap map = SwingUtilities.getUIInputMap(button, 2);
            if (map == null) {
                map = new ComponentInputMapUIResource(button);
                SwingUtilities.replaceUIInputMap(button, 2, map);
            }
            map.clear();
            map.put(KeyStroke.getKeyStroke(m, SwingUtils.getFocusAcceleratorKeyMask(), false), "pressed");
            map.put(KeyStroke.getKeyStroke(m, SwingUtils.getFocusAcceleratorKeyMask(), true), "released");
            map.put(KeyStroke.getKeyStroke(m, 0, true), "released");
        } else {
            InputMap map = SwingUtilities.getUIInputMap(button, 2);
            if (map != null) {
                map.clear();
            }
        }
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (Objects.equals((Object)prop, (Object)"mnemonic")) {
            this.updateMnemonicBinding((AbstractButton)event.getSource());
        }
    }

    @Override
    public void focusGained(@NotNull FocusEvent event) {
        WButtonUI ui;
        JRootPane root;
        AbstractButton button = (AbstractButton)event.getSource();
        if (button instanceof JButton && ((JButton)button).isDefaultCapable() && (root = button.getRootPane()) != null && (ui = (WButtonUI)LafUtils.getUI(button)) != null && LafLookup.getBoolean(button, ui, ui.getPropertyPrefix() + "defaultButtonFollowsFocus", true)) {
            root.putClientProperty("temporaryDefaultButton", button);
            root.setDefaultButton((JButton)button);
            root.putClientProperty("temporaryDefaultButton", null);
        }
    }

    @Override
    public void focusLost(@NotNull FocusEvent event) {
        WButtonUI ui;
        JButton initialDefault;
        AbstractButton button = (AbstractButton)event.getSource();
        JRootPane root = button.getRootPane();
        if (root != null && button != (initialDefault = (JButton)root.getClientProperty("initialDefaultButton")) && (ui = (WButtonUI)LafUtils.getUI(button)) != null && LafLookup.getBoolean(button, ui, ui.getPropertyPrefix() + "defaultButtonFollowsFocus", true)) {
            root.setDefaultButton(initialDefault);
        }
        ButtonModel model = button.getModel();
        model.setPressed(false);
        model.setArmed(false);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event) {
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent event) {
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event) {
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event) {
        AbstractButton button;
        if (SwingUtilities.isLeftMouseButton(event) && (button = (AbstractButton)event.getSource()).contains(event.getX(), event.getY())) {
            long multiClickThreshhold = button.getMultiClickThreshhold();
            long lastTime = this.lastPressedTimestamp;
            long currentTime = this.lastPressedTimestamp = event.getWhen();
            if (lastTime == -1L || currentTime - lastTime >= multiClickThreshhold) {
                ButtonModel model = button.getModel();
                if (model.isEnabled()) {
                    if (!model.isArmed()) {
                        model.setArmed(true);
                    }
                    model.setPressed(true);
                }
                if (button.isEnabled() && !button.hasFocus() && button.isRequestFocusEnabled()) {
                    button.requestFocus();
                }
            } else {
                this.shouldDiscardRelease = true;
            }
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            if (!this.shouldDiscardRelease) {
                AbstractButton button = (AbstractButton)event.getSource();
                ButtonModel model = button.getModel();
                model.setPressed(false);
                model.setArmed(false);
            } else {
                this.shouldDiscardRelease = false;
            }
        }
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent event) {
        AbstractButton button = (AbstractButton)event.getSource();
        ButtonModel model = button.getModel();
        if (button.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(event)) {
            model.setRollover(true);
        }
        if (model.isPressed()) {
            model.setArmed(true);
        }
    }

    @Override
    public void mouseExited(@NotNull MouseEvent event) {
        AbstractButton button = (AbstractButton)event.getSource();
        ButtonModel model = button.getModel();
        if (button.isRolloverEnabled()) {
            model.setRollover(false);
        }
        model.setArmed(false);
    }

    @Override
    public void ancestorAdded(@NotNull AncestorEvent event) {
        AbstractButton button = (AbstractButton)event.getSource();
        button.getModel().setRollover(false);
    }

    @Override
    public void ancestorRemoved(@NotNull AncestorEvent event) {
        AbstractButton button = (AbstractButton)event.getSource();
        button.getModel().setRollover(false);
    }

    @Override
    public void ancestorMoved(@NotNull AncestorEvent event) {
        AbstractButton button = (AbstractButton)event.getSource();
        button.getModel().setRollover(false);
    }

    public static class Action<B extends AbstractButton>
    extends UIAction<B> {
        public static final String PRESSED = "pressed";
        public static final String RELEASED = "released";

        public Action(@NotNull B button, @NotNull String name) {
            super(button, name);
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            AbstractButton button = (AbstractButton)this.getComponent();
            String action = this.getName();
            if (Objects.equals((Object)action, (Object)PRESSED)) {
                ButtonModel model = button.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!button.hasFocus()) {
                    button.requestFocus();
                }
            } else if (Objects.equals((Object)action, (Object)RELEASED)) {
                ButtonModel model = button.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        @Override
        public boolean isEnabled() {
            AbstractButton button = (AbstractButton)this.getComponent();
            return button == null || button.getModel().isEnabled();
        }
    }
}

