/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.HSBColor;
import com.alee.utils.ColorUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;

public class LineColorChooserPaint
implements Paint {
    private boolean webSafe = false;
    private ColorModel model = ColorModel.getRGBdefault();
    private int y;
    private int height;

    public LineColorChooserPaint(int y, int height) {
        this.y = y;
        this.height = height;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, final AffineTransform xform, RenderingHints hints) {
        return new PaintContext(){
            private Map<Rectangle, WritableRaster> rastersCache = new HashMap<Rectangle, WritableRaster>();

            @Override
            public void dispose() {
                this.rastersCache.clear();
            }

            @Override
            public ColorModel getColorModel() {
                return LineColorChooserPaint.this.model;
            }

            @Override
            public Raster getRaster(int x, int y, int w, int h) {
                Rectangle r = new Rectangle(x, y, w, h);
                if (this.rastersCache.containsKey(r)) {
                    return this.rastersCache.get(r);
                }
                WritableRaster raster = LineColorChooserPaint.this.model.createCompatibleWritableRaster(w, h);
                y = (int)((long)y - Math.round(xform.getTranslateY()));
                int[] data = new int[w * h * 4];
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        Color color = new HSBColor(1.0f - (float)(y + j) / (float)(LineColorChooserPaint.this.y * 2 + LineColorChooserPaint.this.height), 1.0f, 1.0f).getColor();
                        int base = (j * w + i) * 4;
                        data[base] = LineColorChooserPaint.this.getWebSafe(color.getRed());
                        data[base + 1] = LineColorChooserPaint.this.getWebSafe(color.getGreen());
                        data[base + 2] = LineColorChooserPaint.this.getWebSafe(color.getBlue());
                        data[base + 3] = 255;
                    }
                }
                raster.setPixels(0, 0, w, h, data);
                this.rastersCache.put(r, raster);
                return raster;
            }
        };
    }

    public Color getColor(int yCoord) {
        return new HSBColor(1.0f - Math.max(0.0f, Math.min((float)(yCoord - this.y) / (float)this.height, 1.0f)), 1.0f, 1.0f).getColor();
    }

    private int getWebSafe(int color) {
        if (this.webSafe) {
            color = ColorUtils.webSafe((int)color);
        }
        if (color < 0) {
            color = 0;
        } else if (color > 255) {
            color = 255;
        }
        return color;
    }

    @Override
    public int getTransparency() {
        return 1;
    }

    public boolean isWebSafe() {
        return this.webSafe;
    }

    public void setWebSafe(boolean webSafe) {
        this.webSafe = webSafe;
    }
}

