/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.WebColorChooser;
import com.alee.laf.window.WebDialog;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.swing.DialogOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;

public class WebColorChooserDialog
extends WebDialog
implements DialogOptions {
    public static final ImageIcon COLOR_CHOOSER_ICON = new ImageIcon(WebColorChooserDialog.class.getResource("icons/color_chooser.png"));
    private final WebColorChooser colorChooser;

    public WebColorChooserDialog() {
        this(new WebColorChooser());
    }

    public WebColorChooserDialog(Component parent) {
        this(new WebColorChooser(), parent);
    }

    public WebColorChooserDialog(String title) {
        this(new WebColorChooser(), title);
    }

    public WebColorChooserDialog(Component parent, String title) {
        this(new WebColorChooser(), parent, title);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser) {
        this(webColorChooser, null, null);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser, Component parent) {
        this(webColorChooser, parent, null);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser, String title) {
        this(webColorChooser, null, title);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser, Component parent, String title) {
        super(CoreSwingUtils.getWindowAncestor((Component)parent), title != null ? title : "weblaf.colorchooser.title");
        this.setIconImage(COLOR_CHOOSER_ICON.getImage());
        this.setLayout(new BorderLayout(0, 0));
        this.colorChooser = webColorChooser;
        this.colorChooser.setOpaque(false);
        this.colorChooser.setShowButtonsPanel(true);
        this.getContentPane().add((Component)this.colorChooser, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                WebColorChooserDialog.this.colorChooser.setResult(-1);
            }
        });
        this.colorChooser.addColorChooserListener(new ColorChooserListener(){

            @Override
            public void okPressed(ActionEvent e) {
                WebColorChooserDialog.this.dispose();
            }

            @Override
            public void resetPressed(ActionEvent e) {
            }

            @Override
            public void cancelPressed(ActionEvent e) {
                WebColorChooserDialog.this.dispose();
            }
        });
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    public int getResult() {
        return this.colorChooser.getResult();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.getResult();
    }

    public Color getColor() {
        return this.colorChooser.getColor();
    }

    public void setColor(Color color) {
        this.colorChooser.setColor(color);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.colorChooser.resetResult();
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(b);
    }
}

