/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.WColorChooserUI;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class WebColorChooserUI
extends WColorChooserUI {
    protected transient WebColorChooserPanel colorChooserPanel;
    protected transient ColorSelectionModel selectionModel;
    protected transient ChangeListener modelChangeListener;
    protected transient boolean modifying = false;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebColorChooserUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.chooser = (JColorChooser)c;
        StyleManager.installSkin(this.chooser);
        this.selectionModel = this.chooser.getSelectionModel();
        this.chooser.setLayout(new BorderLayout());
        this.colorChooserPanel = new WebColorChooserPanel(StyleId.colorchooserContent.at(this.chooser), false);
        this.colorChooserPanel.setColor(this.selectionModel.getSelectedColor());
        this.colorChooserPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!WebColorChooserUI.this.modifying) {
                    WebColorChooserUI.this.modifying = true;
                    WebColorChooserUI.this.selectionModel.setSelectedColor(WebColorChooserUI.this.colorChooserPanel.getColor());
                    WebColorChooserUI.this.modifying = false;
                }
            }
        });
        this.chooser.add((Component)this.colorChooserPanel, "Center");
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!WebColorChooserUI.this.modifying) {
                    WebColorChooserUI.this.modifying = true;
                    WebColorChooserUI.this.colorChooserPanel.setColor(WebColorChooserUI.this.selectionModel.getSelectedColor());
                    WebColorChooserUI.this.modifying = false;
                }
            }
        };
        this.selectionModel.addChangeListener(this.modelChangeListener);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.chooser.remove(this.colorChooserPanel);
        this.chooser.setLayout(null);
        this.selectionModel.removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
        this.colorChooserPanel = null;
        this.selectionModel = null;
        StyleManager.uninstallSkin(this.chooser);
        this.chooser = null;
    }

    @Override
    public boolean isShowButtonsPanel() {
        return this.colorChooserPanel.isShowButtonsPanel();
    }

    @Override
    public void setShowButtonsPanel(boolean display) {
        this.colorChooserPanel.setShowButtonsPanel(display);
    }

    @Override
    public boolean isWebOnlyColors() {
        return this.colorChooserPanel.isWebOnlyColors();
    }

    @Override
    public void setWebOnlyColors(boolean webOnly) {
        this.colorChooserPanel.setWebOnlyColors(webOnly);
    }

    @Override
    public Color getPreviousColor() {
        return this.colorChooserPanel.getOldColor();
    }

    @Override
    public void setPreviousColor(Color previous) {
        this.colorChooserPanel.setOldColor(previous);
    }

    @Override
    public void resetResult() {
        this.colorChooserPanel.resetResult();
    }

    @Override
    public void setResult(int result) {
        this.colorChooserPanel.setResult(result);
    }

    @Override
    public int getResult() {
        return this.colorChooserPanel.getResult();
    }

    @Override
    public void addColorChooserListener(@NotNull ColorChooserListener listener) {
        this.colorChooserPanel.addColorChooserListener(listener);
    }

    @Override
    public void removeColorChooserListener(@NotNull ColorChooserListener listener) {
        this.colorChooserPanel.removeColorChooserListener(listener);
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return null;
    }
}

