/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.laf.list.WebListModel;
import com.alee.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.MutableComboBoxModel;

public class WebComboBoxModel<T>
extends WebListModel<T>
implements MutableComboBoxModel {
    protected T selected = this.getSize() > 0 ? this.getElementAt(0) : null;

    public WebComboBoxModel() {
        this(new ArrayList(0));
    }

    public WebComboBoxModel(T ... elements) {
        this(CollectionUtils.asList((Object[])elements));
    }

    public WebComboBoxModel(Collection<T> elements) {
        super(elements);
    }

    public void addElement(Object element) {
        this.add(element);
    }

    public void insertElementAt(Object element, int index) {
        this.add(index, element);
    }

    @Override
    public void removeElement(Object element) {
        this.remove(element);
    }

    @Override
    public void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public T getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object element) {
        if (this.selected != null && !this.selected.equals(element) || this.selected == null && element != null) {
            this.selected = element;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public T get(int index) {
        return index >= 0 && index < this.delegate.size() ? (T)super.get(index) : null;
    }

    @Override
    public void addAll(int index, Collection<T> elements) {
        super.addAll(index, elements);
        if (this.size() == 1 && this.selected == null && CollectionUtils.notEmpty(elements)) {
            this.setSelectedItem(elements.iterator().next());
        }
    }

    @Override
    public T set(int index, T element) {
        int selectedIndex = this.indexOf(this.selected);
        if (selectedIndex == index) {
            this.setSelectedItem(element);
        }
        return super.set(index, element);
    }

    @Override
    public void removeInterval(int start, int end) {
        int selectedIndex = this.indexOf(this.selected);
        if (start <= selectedIndex && selectedIndex <= end) {
            int index = end < this.delegate.size() - 1 ? end + 1 : (start > 0 ? start - 1 : -1);
            this.setSelectedItem(index != -1 ? this.get(index) : null);
        }
        super.removeInterval(start, end);
    }
}

