/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.api.annotations.NotNull;
import com.alee.laf.combobox.ComboBoxCellParameters;
import com.alee.laf.list.ListCellParameters;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.managers.style.StyleId;
import com.alee.utils.TextUtils;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JList;

public class WebComboBoxRenderer<V, C extends JList, P extends ComboBoxCellParameters<V, C>>
extends WebListCellRenderer<V, C, P> {
    @Override
    protected void updateStates(P parameters) {
        super.updateStates(parameters);
        if (((ComboBoxCellParameters)parameters).comboBox().isPopupVisible()) {
            this.states.add("pressed");
            this.states.add("expanded");
        } else {
            this.states.add("collapsed");
        }
    }

    @Override
    protected void updateStyleId(P parameters) {
        if (((ListCellParameters)parameters).index() == -1) {
            this.setStyleId(StyleId.comboboxBoxRenderer.at((JComponent)((ListCellParameters)parameters).list()));
        } else {
            this.setStyleId(StyleId.comboboxListRenderer.at((JComponent)((ListCellParameters)parameters).list()));
        }
    }

    @Override
    protected P getRenderingParameters(C list, V value, int index, boolean isSelected, boolean hasFocus) {
        return (P)new ComboBoxCellParameters<V, C>(list, value, index, isSelected, hasFocus);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension size;
        if (this.isEmptyData()) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    protected boolean isEmptyData() {
        return TextUtils.isEmpty((String)this.getText()) && this.getIcon() == null;
    }

    public static final class UIResource<V, C extends JList, P extends ComboBoxCellParameters<V, C>>
    extends WebComboBoxRenderer<V, C, P>
    implements javax.swing.plaf.UIResource {
    }
}

